/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.concurrent;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import org.neo4j.concurrent.AsyncEvent;
import org.neo4j.concurrent.AsyncEventSender;
import org.neo4j.concurrent.BinaryLatch;

public class AsyncEvents<T extends AsyncEvent>
implements AsyncEventSender<T>,
Runnable {
    private static final AtomicReferenceFieldUpdater<AsyncEvents, AsyncEvent> STACK = AtomicReferenceFieldUpdater.newUpdater(AsyncEvents.class, AsyncEvent.class, "stack");
    private static final Sentinel END_SENTINEL = new Sentinel("END");
    private static final Sentinel SHUTDOWN_SENTINEL = new Sentinel("SHUTDOWN");
    private final Consumer<T> eventConsumer;
    private final Monitor monitor;
    private final BinaryLatch startupLatch;
    private final BinaryLatch shutdownLatch;
    private volatile AsyncEvent stack;
    private volatile Thread backgroundThread;
    private volatile boolean shutdown;

    public AsyncEvents(Consumer<T> eventConsumer, Monitor monitor) {
        this.eventConsumer = eventConsumer;
        this.monitor = monitor;
        this.startupLatch = new BinaryLatch();
        this.shutdownLatch = new BinaryLatch();
        this.stack = END_SENTINEL;
    }

    @Override
    public void send(T event) {
        AsyncEvent prev = STACK.getAndSet(this, (AsyncEvent)event);
        assert (prev != null);
        ((AsyncEvent)event).next = prev;
        if (prev == END_SENTINEL) {
            LockSupport.unpark(this.backgroundThread);
        } else if (prev == SHUTDOWN_SENTINEL) {
            AsyncEvent events2 = STACK.getAndSet(this, SHUTDOWN_SENTINEL);
            this.process(events2);
        }
    }

    @Override
    public void run() {
        assert (this.backgroundThread == null) : "A thread is already running " + this.backgroundThread;
        this.backgroundThread = Thread.currentThread();
        this.startupLatch.release();
        try {
            AsyncEvent events2;
            do {
                events2 = STACK.getAndSet(this, END_SENTINEL);
                this.process(events2);
                if (this.stack != END_SENTINEL || this.shutdown) continue;
                LockSupport.park(this);
            } while (!this.shutdown);
            events2 = STACK.getAndSet(this, SHUTDOWN_SENTINEL);
            this.process(events2);
        }
        finally {
            this.backgroundThread = null;
            this.shutdownLatch.release();
        }
    }

    private void process(AsyncEvent events2) {
        events2 = this.reverseAndStripEndMark(events2);
        Consumer<AsyncEvent> consumer = this.eventConsumer;
        while (events2 != null) {
            AsyncEvent event = events2;
            consumer.accept(event);
            events2 = events2.next;
        }
    }

    private AsyncEvent reverseAndStripEndMark(AsyncEvent events2) {
        AsyncEvent result2 = null;
        long count2 = 0L;
        while (events2 != END_SENTINEL && events2 != SHUTDOWN_SENTINEL) {
            AsyncEvent next2;
            while ((next2 = events2.next) == null) {
            }
            events2.next = result2;
            result2 = events2;
            events2 = next2;
            ++count2;
        }
        if (count2 > 0L) {
            this.monitor.eventCount(count2);
        }
        return result2;
    }

    public void shutdown() {
        assert (this.backgroundThread != null) : "Already shut down";
        this.shutdown = true;
        LockSupport.unpark(this.backgroundThread);
    }

    public void awaitStartup() {
        this.startupLatch.await();
    }

    public void awaitTermination() throws InterruptedException {
        this.shutdownLatch.await();
    }

    private static class Sentinel
    extends AsyncEvent {
        private final String str;

        Sentinel(String identifier2) {
            this.str = "AsyncEvent/Sentinel[" + identifier2 + "]";
        }

        public String toString() {
            return this.str;
        }
    }

    public static interface Monitor {
        public static final Monitor NONE = count2 -> {};

        public void eventCount(long var1);
    }
}

