/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import org.neo4j.collection.primitive.hopscotch.PowerOfTwoQuantizedTable;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

public abstract class UnsafeTable<VALUE>
extends PowerOfTwoQuantizedTable<VALUE> {
    private final int bytesPerKey;
    private final int bytesPerEntry;
    private final long dataSize;
    private final long address;
    protected final VALUE valueMarker;

    protected UnsafeTable(int capacity, int bytesPerKey, VALUE valueMarker) {
        super(capacity, 32);
        UnsafeUtil.assertHasUnsafe();
        this.bytesPerKey = bytesPerKey;
        this.bytesPerEntry = 4 + bytesPerKey;
        this.valueMarker = valueMarker;
        this.dataSize = (long)this.capacity * (long)this.bytesPerEntry;
        this.address = UnsafeUtil.allocateMemory(this.dataSize);
        this.clearMemory();
    }

    @Override
    public void clear() {
        if (!this.isEmpty()) {
            this.clearMemory();
        }
        super.clear();
    }

    private void clearMemory() {
        UnsafeUtil.setMemory(this.address, this.dataSize, (byte)-1);
    }

    @Override
    public long key(int index) {
        return this.internalKey(this.keyAddress(index));
    }

    protected abstract long internalKey(long var1);

    @Override
    public VALUE value(int index) {
        return this.valueMarker;
    }

    @Override
    public void put(int index, long key, VALUE value) {
        this.internalPut(this.keyAddress(index), key, value);
        ++this.size;
    }

    protected abstract void internalPut(long var1, long var3, VALUE var5);

    @Override
    public VALUE putValue(int index, VALUE value) {
        return value;
    }

    @Override
    public long move(int fromIndex, int toIndex) {
        long adr = this.keyAddress(fromIndex);
        long key = this.internalKey(adr);
        VALUE value = this.internalRemove(adr);
        this.internalPut(this.keyAddress(toIndex), key, value);
        return key;
    }

    @Override
    public VALUE remove(int index) {
        VALUE value = this.internalRemove(this.keyAddress(index));
        --this.size;
        return value;
    }

    protected VALUE internalRemove(long keyAddress) {
        UnsafeUtil.setMemory(keyAddress, this.bytesPerKey, (byte)-1);
        return this.valueMarker;
    }

    @Override
    public long hopBits(int index) {
        return ((long)UnsafeUtil.getInt(this.hopBitsAddress(index)) | 0xFFFFFFFF00000000L) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public void putHopBit(int index, int hd) {
        long adr = this.hopBitsAddress(index);
        int hopBits = UnsafeUtil.getInt(adr);
        UnsafeUtil.putInt(adr, hopBits &= ~(1 << hd));
    }

    @Override
    public void moveHopBit(int index, int hd, int delta) {
        long adr = this.hopBitsAddress(index);
        int hopBits = UnsafeUtil.getInt(adr);
        UnsafeUtil.putInt(adr, hopBits ^= 1 << hd | 1 << hd + delta);
    }

    protected long keyAddress(int index) {
        return this.address + (long)index * (long)this.bytesPerEntry + 4L;
    }

    protected long hopBitsAddress(int index) {
        return this.address + (long)index * (long)this.bytesPerEntry;
    }

    @Override
    public void removeHopBit(int index, int hd) {
        long adr = this.hopBitsAddress(index);
        int hopBits = UnsafeUtil.getInt(adr);
        UnsafeUtil.putInt(adr, hopBits |= 1 << hd);
    }

    @Override
    public void close() {
        UnsafeUtil.free(this.address);
    }
}

