/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import org.neo4j.collection.primitive.PrimitiveLongLongMap;
import org.neo4j.collection.primitive.PrimitiveLongLongVisitor;
import org.neo4j.collection.primitive.hopscotch.AbstractLongHopScotchCollection;
import org.neo4j.collection.primitive.hopscotch.HopScotchHashingAlgorithm;
import org.neo4j.collection.primitive.hopscotch.Table;

public class PrimitiveLongLongHashMap
extends AbstractLongHopScotchCollection<long[]>
implements PrimitiveLongLongMap {
    private final long[] transport = new long[1];
    private final HopScotchHashingAlgorithm.Monitor monitor;

    public PrimitiveLongLongHashMap(Table<long[]> table, HopScotchHashingAlgorithm.Monitor monitor) {
        super(table);
        this.monitor = monitor;
    }

    @Override
    public long put(long key, long value) {
        return this.unpack(HopScotchHashingAlgorithm.put(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key, this.pack(value), this));
    }

    @Override
    public boolean containsKey(long key) {
        return HopScotchHashingAlgorithm.get(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key) != null;
    }

    @Override
    public long get(long key) {
        return this.unpack((long[])HopScotchHashingAlgorithm.get(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key));
    }

    @Override
    public long remove(long key) {
        return this.unpack((long[])HopScotchHashingAlgorithm.remove(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key));
    }

    @Override
    public int size() {
        return this.table.size();
    }

    @Override
    public String toString() {
        return this.table.toString();
    }

    private long[] pack(long value) {
        this.transport[0] = value;
        return this.transport;
    }

    private long unpack(long[] result2) {
        return result2 != null ? result2[0] : -1L;
    }

    @Override
    public <E extends Exception> void visitEntries(PrimitiveLongLongVisitor<E> visitor) throws E {
        long nullKey = this.table.nullKey();
        int capacity = this.table.capacity();
        for (int i = 0; i < capacity; ++i) {
            long[] value;
            long key = this.table.key(i);
            if (key == nullKey || (value = (long[])this.table.value(i)) == null || !visitor.visited(key, value[0])) continue;
            return;
        }
    }

    @Override
    public boolean equals(Object other2) {
        if (this.typeAndSizeEqual(other2)) {
            PrimitiveLongLongHashMap that = (PrimitiveLongLongHashMap)other2;
            LongLongEquality equality = new LongLongEquality(that);
            this.visitEntries(equality);
            return equality.isEqual();
        }
        return false;
    }

    @Override
    public int hashCode() {
        HashCodeComputer hash = new HashCodeComputer();
        this.visitEntries(hash);
        return hash.hashCode();
    }

    private static class HashCodeComputer
    implements PrimitiveLongLongVisitor<RuntimeException> {
        private int hash = 1337;

        private HashCodeComputer() {
        }

        @Override
        public boolean visited(long key, long value) throws RuntimeException {
            this.hash += HopScotchHashingAlgorithm.DEFAULT_HASHING.hash(key + (long)HopScotchHashingAlgorithm.DEFAULT_HASHING.hash(value));
            return false;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static class LongLongEquality
    implements PrimitiveLongLongVisitor<RuntimeException> {
        private PrimitiveLongLongHashMap other;
        private boolean equal = true;

        public LongLongEquality(PrimitiveLongLongHashMap that) {
            this.other = that;
        }

        @Override
        public boolean visited(long key, long value) {
            this.equal = this.other.get(key) == value;
            return !this.equal;
        }

        public boolean isEqual() {
            return this.equal;
        }
    }
}

