/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import org.neo4j.collection.primitive.PrimitiveIntLongMap;
import org.neo4j.collection.primitive.PrimitiveIntLongVisitor;
import org.neo4j.collection.primitive.hopscotch.AbstractIntHopScotchCollection;
import org.neo4j.collection.primitive.hopscotch.HopScotchHashingAlgorithm;
import org.neo4j.collection.primitive.hopscotch.Table;

public class PrimitiveIntLongHashMap
extends AbstractIntHopScotchCollection<long[]>
implements PrimitiveIntLongMap {
    private final long[] transport = new long[1];
    private final HopScotchHashingAlgorithm.Monitor monitor;

    public PrimitiveIntLongHashMap(Table<long[]> table, HopScotchHashingAlgorithm.Monitor monitor) {
        super(table);
        this.monitor = monitor;
    }

    @Override
    public long put(int key, long value) {
        return this.unpack(HopScotchHashingAlgorithm.put(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key, this.pack(value), this));
    }

    @Override
    public boolean containsKey(int key) {
        return HopScotchHashingAlgorithm.get(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key) != null;
    }

    @Override
    public long get(int key) {
        return this.unpack((long[])HopScotchHashingAlgorithm.get(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key));
    }

    @Override
    public long remove(int key) {
        return this.unpack((long[])HopScotchHashingAlgorithm.remove(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key));
    }

    @Override
    public int size() {
        return this.table.size();
    }

    @Override
    public String toString() {
        return this.table.toString();
    }

    @Override
    public <E extends Exception> void visitEntries(PrimitiveIntLongVisitor<E> visitor) throws E {
        long nullKey = this.table.nullKey();
        int capacity = this.table.capacity();
        for (int i = 0; i < capacity; ++i) {
            long[] value;
            int key = (int)this.table.key(i);
            if ((long)key == nullKey || (value = (long[])this.table.value(i)) == null || !visitor.visited(key, value[0])) continue;
            return;
        }
    }

    private long[] pack(long value) {
        this.transport[0] = value;
        return this.transport;
    }

    private long unpack(long[] result2) {
        return result2 != null ? result2[0] : -1L;
    }

    @Override
    public boolean equals(Object other2) {
        if (this.typeAndSizeEqual(other2)) {
            PrimitiveIntLongHashMap that = (PrimitiveIntLongHashMap)other2;
            IntLongEquality equality = new IntLongEquality(that);
            this.visitEntries(equality);
            return equality.isEqual();
        }
        return false;
    }

    @Override
    public int hashCode() {
        HashCodeComputer hash = new HashCodeComputer();
        this.visitEntries(hash);
        return hash.hashCode();
    }

    private static class HashCodeComputer
    implements PrimitiveIntLongVisitor<RuntimeException> {
        private int hash = 1337;

        private HashCodeComputer() {
        }

        @Override
        public boolean visited(int key, long value) throws RuntimeException {
            this.hash += HopScotchHashingAlgorithm.DEFAULT_HASHING.hash(key + HopScotchHashingAlgorithm.DEFAULT_HASHING.hash(value));
            return false;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static class IntLongEquality
    implements PrimitiveIntLongVisitor<RuntimeException> {
        private PrimitiveIntLongHashMap other;
        private boolean equal = true;

        public IntLongEquality(PrimitiveIntLongHashMap that) {
            this.other = that;
        }

        @Override
        public boolean visited(int key, long value) {
            this.equal = this.other.get(key) == value;
            return !this.equal;
        }

        public boolean isEqual() {
            return this.equal;
        }
    }
}

