/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveCommons;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.collection.primitive.base.Empty;
import org.neo4j.graphdb.Resource;

public class PrimitiveLongCollections {
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final PrimitiveLongIterator EMPTY = new PrimitiveLongBaseIterator(){

        @Override
        protected boolean fetchNext() {
            return false;
        }
    };

    public static PrimitiveLongIterator iterator(final long ... items) {
        return new PrimitiveLongBaseIterator(){
            private int index = -1;

            @Override
            protected boolean fetchNext() {
                return ++this.index < items.length ? this.next(items[this.index]) : false;
            }
        };
    }

    public static PrimitiveLongIterator reversed(final long ... items) {
        return new PrimitiveLongBaseIterator(){
            private int index;
            {
                this.index = items.length;
            }

            @Override
            protected boolean fetchNext() {
                return --this.index >= 0 ? this.next(items[this.index]) : false;
            }
        };
    }

    public static PrimitiveLongIterator reversed(PrimitiveLongIterator source) {
        long[] items = PrimitiveLongCollections.asArray(source);
        return PrimitiveLongCollections.reversed(items);
    }

    public static PrimitiveLongIterator concat(Iterable<PrimitiveLongIterator> primitiveLongIterators) {
        return new PrimitiveLongConcatingIterator(primitiveLongIterators.iterator());
    }

    public static PrimitiveLongIterator concat(Iterator<PrimitiveLongIterator> iterators) {
        return new PrimitiveLongConcatingIterator(iterators);
    }

    public static PrimitiveLongIterator prepend(final long item, final PrimitiveLongIterator iterator2) {
        return new PrimitiveLongBaseIterator(){
            private boolean singleItemReturned;

            @Override
            protected boolean fetchNext() {
                if (!this.singleItemReturned) {
                    this.singleItemReturned = true;
                    return this.next(item);
                }
                return iterator2.hasNext() ? this.next(iterator2.next()) : false;
            }
        };
    }

    public static PrimitiveLongIterator append(final PrimitiveLongIterator iterator2, final long item) {
        return new PrimitiveLongBaseIterator(){
            private boolean singleItemReturned;

            @Override
            protected boolean fetchNext() {
                if (iterator2.hasNext()) {
                    return this.next(iterator2.next());
                }
                if (!this.singleItemReturned) {
                    this.singleItemReturned = true;
                    return this.next(item);
                }
                return false;
            }
        };
    }

    public static PrimitiveLongIterator filter(PrimitiveLongIterator source, final LongPredicate filter2) {
        return new PrimitiveLongFilteringIterator(source){

            @Override
            public boolean test(long item) {
                return filter2.test(item);
            }
        };
    }

    public static PrimitiveLongIterator dedup(PrimitiveLongIterator source) {
        return new PrimitiveLongFilteringIterator(source){
            private final PrimitiveLongSet visited = Primitive.longSet();

            @Override
            public boolean test(long testItem) {
                return this.visited.add(testItem);
            }
        };
    }

    public static PrimitiveLongIterator not(PrimitiveLongIterator source, final long disallowedValue) {
        return new PrimitiveLongFilteringIterator(source){

            @Override
            public boolean test(long testItem) {
                return testItem != disallowedValue;
            }
        };
    }

    public static PrimitiveLongIterator skip(PrimitiveLongIterator source, final int skipTheFirstNItems) {
        return new PrimitiveLongFilteringIterator(source){
            private int skipped;
            {
                super(source);
                this.skipped = 0;
            }

            @Override
            public boolean test(long item) {
                if (this.skipped < skipTheFirstNItems) {
                    ++this.skipped;
                    return false;
                }
                return true;
            }
        };
    }

    public static PrimitiveLongIterator limit(final PrimitiveLongIterator source, final int maxItems) {
        return new PrimitiveLongBaseIterator(){
            private int visited;

            @Override
            protected boolean fetchNext() {
                if (this.visited++ < maxItems && source.hasNext()) {
                    return this.next(source.next());
                }
                return false;
            }
        };
    }

    public static PrimitiveLongIterator range(long end) {
        return PrimitiveLongCollections.range(0L, end);
    }

    public static PrimitiveLongIterator range(long start, long end) {
        return PrimitiveLongCollections.range(start, end, 1L);
    }

    public static PrimitiveLongIterator range(long start, long end, long stride) {
        return new PrimitiveLongRangeIterator(start, end, stride);
    }

    public static PrimitiveLongIterator singleton(final long item) {
        return new PrimitiveLongBaseIterator(){
            private boolean returned;

            @Override
            protected boolean fetchNext() {
                try {
                    boolean bl = !this.returned ? this.next(item) : false;
                    return bl;
                }
                finally {
                    this.returned = true;
                }
            }
        };
    }

    public static long first(PrimitiveLongIterator iterator2) {
        PrimitiveLongCollections.assertMoreItems(iterator2);
        return iterator2.next();
    }

    private static void assertMoreItems(PrimitiveLongIterator iterator2) {
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException("No element in " + iterator2);
        }
    }

    public static long first(PrimitiveLongIterator iterator2, long defaultItem) {
        return iterator2.hasNext() ? iterator2.next() : defaultItem;
    }

    public static long last(PrimitiveLongIterator iterator2) {
        PrimitiveLongCollections.assertMoreItems(iterator2);
        return PrimitiveLongCollections.last(iterator2, 0L);
    }

    public static long last(PrimitiveLongIterator iterator2, long defaultItem) {
        long result2 = defaultItem;
        while (iterator2.hasNext()) {
            result2 = iterator2.next();
        }
        return result2;
    }

    public static long single(PrimitiveLongIterator iterator2) {
        try {
            PrimitiveLongCollections.assertMoreItems(iterator2);
            long item = iterator2.next();
            if (iterator2.hasNext()) {
                throw new NoSuchElementException("More than one item in " + iterator2 + ", first:" + item + ", second:" + iterator2.next());
            }
            PrimitiveCommons.closeSafely(iterator2);
            return item;
        }
        catch (NoSuchElementException exception) {
            PrimitiveCommons.closeSafely(iterator2, exception);
            throw exception;
        }
    }

    public static long single(PrimitiveLongIterator iterator2, long defaultItem) {
        try {
            if (!iterator2.hasNext()) {
                PrimitiveCommons.closeSafely(iterator2);
                return defaultItem;
            }
            long item = iterator2.next();
            if (iterator2.hasNext()) {
                throw new NoSuchElementException("More than one item in " + iterator2 + ", first:" + item + ", second:" + iterator2.next());
            }
            PrimitiveCommons.closeSafely(iterator2);
            return item;
        }
        catch (NoSuchElementException exception) {
            PrimitiveCommons.closeSafely(iterator2, exception);
            throw exception;
        }
    }

    public static long itemAt(PrimitiveLongIterator iterator2, int index) {
        if (index >= 0) {
            for (int i = 0; iterator2.hasNext() && i < index; ++i) {
                iterator2.next();
            }
            PrimitiveLongCollections.assertMoreItems(iterator2);
            return iterator2.next();
        }
        int fromEnd = index * -1;
        long[] trail = new long[fromEnd];
        int cursor = 0;
        while (iterator2.hasNext()) {
            trail[cursor % trail.length] = iterator2.next();
            ++cursor;
        }
        if (cursor < fromEnd) {
            throw new NoSuchElementException("Item " + index + " not found in " + iterator2);
        }
        return trail[cursor % fromEnd];
    }

    public static long itemAt(PrimitiveLongIterator iterator2, int index, long defaultItem) {
        if (index >= 0) {
            for (int i = 0; iterator2.hasNext() && i < index; ++i) {
                iterator2.next();
            }
            return iterator2.hasNext() ? iterator2.next() : defaultItem;
        }
        int fromEnd = index * -1;
        long[] trail = new long[fromEnd];
        int cursor = 0;
        while (iterator2.hasNext()) {
            trail[cursor % trail.length] = iterator2.next();
            ++cursor;
        }
        return cursor < fromEnd ? defaultItem : trail[cursor % fromEnd];
    }

    public static int indexOf(PrimitiveLongIterator iterator2, long item) {
        int i = 0;
        while (iterator2.hasNext()) {
            if (item == iterator2.next()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean equals(PrimitiveLongIterator first, PrimitiveLongIterator other2) {
        boolean otherHasNext;
        boolean firstHasNext;
        while ((firstHasNext = first.hasNext()) | (otherHasNext = other2.hasNext())) {
            if (firstHasNext == otherHasNext && first.next() == other2.next()) continue;
            return false;
        }
        return true;
    }

    public static PrimitiveLongSet asSet(PrimitiveLongIterator iterator2) {
        PrimitiveLongSet set = Primitive.longSet();
        while (iterator2.hasNext()) {
            long next2 = iterator2.next();
            if (set.add(next2)) continue;
            throw new IllegalStateException("Duplicate " + next2 + " from " + iterator2);
        }
        return set;
    }

    public static PrimitiveLongSet asSetAllowDuplicates(PrimitiveLongIterator iterator2) {
        PrimitiveLongSet set = Primitive.longSet();
        while (iterator2.hasNext()) {
            set.add(iterator2.next());
        }
        return set;
    }

    public static int count(PrimitiveLongIterator iterator2) {
        int count2 = 0;
        while (iterator2.hasNext()) {
            iterator2.next();
            ++count2;
        }
        return count2;
    }

    public static long[] asArray(PrimitiveLongIterator iterator2) {
        long[] array = new long[8];
        int i = 0;
        while (iterator2.hasNext()) {
            if (i >= array.length) {
                array = Arrays.copyOf(array, i << 1);
            }
            array[i] = iterator2.next();
            ++i;
        }
        if (i < array.length) {
            array = Arrays.copyOf(array, i);
        }
        return array;
    }

    public static long[] asArray(Iterator<Long> iterator2) {
        long[] array = new long[8];
        int i = 0;
        while (iterator2.hasNext()) {
            if (i >= array.length) {
                array = Arrays.copyOf(array, i << 1);
            }
            array[i] = iterator2.next();
            ++i;
        }
        if (i < array.length) {
            array = Arrays.copyOf(array, i);
        }
        return array;
    }

    public static PrimitiveLongIterator emptyIterator() {
        return EMPTY;
    }

    public static PrimitiveLongIterator toPrimitiveIterator(final Iterator<Long> iterator2) {
        return new PrimitiveLongBaseIterator(){

            @Override
            protected boolean fetchNext() {
                if (iterator2.hasNext()) {
                    Long nextValue = (Long)iterator2.next();
                    if (null == nextValue) {
                        throw new IllegalArgumentException("Cannot convert null Long to primitive long");
                    }
                    return this.next(nextValue);
                }
                return false;
            }
        };
    }

    public static PrimitiveLongSet emptySet() {
        return Empty.EMPTY_PRIMITIVE_LONG_SET;
    }

    public static PrimitiveLongSet setOf(long ... values2) {
        Objects.requireNonNull(values2, "Values array is null");
        PrimitiveLongSet set = Primitive.longSet(values2.length);
        for (long value : values2) {
            set.add(value);
        }
        return set;
    }

    public static <T> Iterator<T> map(final LongFunction<T> mapFunction, final PrimitiveLongIterator source) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return source.hasNext();
            }

            @Override
            public T next() {
                return mapFunction.apply(source.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static PrimitiveLongIterator constant(final long value) {
        return new PrimitiveLongBaseIterator(){

            @Override
            protected boolean fetchNext() {
                return this.next(value);
            }
        };
    }

    public static <T> PrimitiveLongObjectMap<T> emptyObjectMap() {
        return Empty.EMPTY_PRIMITIVE_LONG_OBJECT_MAP;
    }

    public static <C extends Collection<Long>> C addToCollection(PrimitiveLongIterator iterator2, C collection) {
        while (iterator2.hasNext()) {
            collection.add(iterator2.next());
        }
        return collection;
    }

    public static List<Long> asList(PrimitiveLongIterator iterator2) {
        ArrayList<Long> out = new ArrayList<Long>();
        while (iterator2.hasNext()) {
            out.add(iterator2.next());
        }
        return out;
    }

    public static Iterator<Long> toIterator(final PrimitiveLongIterator primIterator) {
        return new Iterator<Long>(){

            @Override
            public boolean hasNext() {
                return primIterator.hasNext();
            }

            @Override
            public Long next() {
                return primIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static PrimitiveLongResourceIterator resourceIterator(final PrimitiveLongIterator iterator2, final Resource resource) {
        return new PrimitiveLongResourceIterator(){

            @Override
            public void close() {
                if (resource != null) {
                    resource.close();
                }
            }

            @Override
            public long next() {
                return iterator2.next();
            }

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }
        };
    }

    public static Set<Long> toSet(PrimitiveLongIterator iterator2) {
        HashSet<Long> set = new HashSet<Long>();
        while (iterator2.hasNext()) {
            PrimitiveLongCollections.addUnique(set, iterator2.next());
        }
        return set;
    }

    private static <T, C extends Collection<T>> void addUnique(C collection, T item) {
        if (!collection.add(item)) {
            throw new IllegalStateException("Encountered an already added item:" + item + " when adding items uniquely to a collection:" + collection);
        }
    }

    public static class PrimitiveLongRangeIterator
    extends PrimitiveLongBaseIterator {
        private long current;
        private final long end;
        private final long stride;

        public PrimitiveLongRangeIterator(long start, long end, long stride) {
            this.current = start;
            this.end = end;
            this.stride = stride;
        }

        @Override
        protected boolean fetchNext() {
            try {
                boolean bl = this.current <= this.end ? this.next(this.current) : false;
                return bl;
            }
            finally {
                this.current += this.stride;
            }
        }
    }

    public static abstract class PrimitiveLongFilteringIterator
    extends PrimitiveLongBaseIterator
    implements LongPredicate {
        private final PrimitiveLongIterator source;

        public PrimitiveLongFilteringIterator(PrimitiveLongIterator source) {
            this.source = source;
        }

        @Override
        protected boolean fetchNext() {
            while (this.source.hasNext()) {
                long testItem = this.source.next();
                if (!this.test(testItem)) continue;
                return this.next(testItem);
            }
            return false;
        }

        @Override
        public abstract boolean test(long var1);
    }

    public static class PrimitiveLongInterleavingIterator
    extends PrimitiveLongBaseIterator {
        private final Iterable<PrimitiveLongIterator> iterators;
        private Iterator<PrimitiveLongIterator> currentRound;

        public PrimitiveLongInterleavingIterator(Iterable<PrimitiveLongIterator> iterators) {
            this.iterators = iterators;
        }

        @Override
        protected boolean fetchNext() {
            if (this.currentRound == null || !this.currentRound.hasNext()) {
                this.currentRound = this.iterators.iterator();
            }
            while (this.currentRound.hasNext()) {
                PrimitiveLongIterator iterator2 = this.currentRound.next();
                if (!iterator2.hasNext()) continue;
                return this.next(iterator2.next());
            }
            this.currentRound = null;
            return false;
        }
    }

    public static class PrimitiveLongConcatingIterator
    extends PrimitiveLongBaseIterator {
        private final Iterator<? extends PrimitiveLongIterator> iterators;
        private PrimitiveLongIterator currentIterator;

        public PrimitiveLongConcatingIterator(Iterator<? extends PrimitiveLongIterator> iterators) {
            this.iterators = iterators;
        }

        @Override
        protected boolean fetchNext() {
            if (this.currentIterator == null || !this.currentIterator.hasNext()) {
                while (this.iterators.hasNext()) {
                    this.currentIterator = this.iterators.next();
                    if (!this.currentIterator.hasNext()) continue;
                }
            }
            return this.currentIterator != null && this.currentIterator.hasNext() ? this.next(this.currentIterator.next()) : false;
        }

        protected final PrimitiveLongIterator currentIterator() {
            return this.currentIterator;
        }
    }

    public static abstract class PrimitiveLongBaseIterator
    implements PrimitiveLongIterator {
        private boolean hasNext;
        protected long next;

        @Override
        public boolean hasNext() {
            return this.hasNext ? true : (this.hasNext = this.fetchNext());
        }

        @Override
        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements in " + this);
            }
            this.hasNext = false;
            return this.next;
        }

        protected abstract boolean fetchNext();

        protected boolean next(long nextItem) {
            this.next = nextItem;
            this.hasNext = true;
            return true;
        }
    }
}

