/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveCommons;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.collection.primitive.base.Empty;

public class PrimitiveIntCollections {
    private static final PrimitiveIntIterator EMPTY = new PrimitiveIntBaseIterator(){

        @Override
        protected boolean fetchNext() {
            return false;
        }
    };

    public static PrimitiveIntIterator iterator(final int ... items) {
        return new PrimitiveIntBaseIterator(){
            private int index = -1;

            @Override
            protected boolean fetchNext() {
                return ++this.index < items.length ? this.next(items[this.index]) : false;
            }
        };
    }

    public static PrimitiveIntIterator reversed(final int ... items) {
        return new PrimitiveIntBaseIterator(){
            private int index;
            {
                this.index = items.length;
            }

            @Override
            protected boolean fetchNext() {
                return --this.index >= 0 ? this.next(items[this.index]) : false;
            }
        };
    }

    public static PrimitiveIntIterator reversed(PrimitiveIntIterator source) {
        int[] items = PrimitiveIntCollections.asArray(source);
        return PrimitiveIntCollections.reversed(items);
    }

    public static PrimitiveIntIterator concat(Iterator<PrimitiveIntIterator> iterators) {
        return new PrimitiveIntConcatingIterator(iterators);
    }

    public static PrimitiveIntIterator prepend(final int item, final PrimitiveIntIterator iterator2) {
        return new PrimitiveIntBaseIterator(){
            private boolean singleItemReturned;

            @Override
            protected boolean fetchNext() {
                if (!this.singleItemReturned) {
                    this.singleItemReturned = true;
                    return this.next(item);
                }
                return iterator2.hasNext() ? this.next(iterator2.next()) : false;
            }
        };
    }

    public static PrimitiveIntIterator append(final PrimitiveIntIterator iterator2, final int item) {
        return new PrimitiveIntBaseIterator(){
            private boolean singleItemReturned;

            @Override
            protected boolean fetchNext() {
                if (iterator2.hasNext()) {
                    return this.next(iterator2.next());
                }
                if (!this.singleItemReturned) {
                    this.singleItemReturned = true;
                    return this.next(item);
                }
                return false;
            }
        };
    }

    public static PrimitiveIntIterator filter(PrimitiveIntIterator source, final IntPredicate filter2) {
        return new PrimitiveIntFilteringIterator(source){

            @Override
            public boolean test(int item) {
                return filter2.test(item);
            }
        };
    }

    public static PrimitiveIntIterator dedup(PrimitiveIntIterator source) {
        return new PrimitiveIntFilteringIterator(source){
            private final PrimitiveIntSet visited = Primitive.intSet();

            @Override
            public boolean test(int testItem) {
                return this.visited.add(testItem);
            }
        };
    }

    public static PrimitiveIntIterator not(PrimitiveIntIterator source, final int disallowedValue) {
        return new PrimitiveIntFilteringIterator(source){

            @Override
            public boolean test(int testItem) {
                return testItem != disallowedValue;
            }
        };
    }

    public static PrimitiveIntIterator skip(PrimitiveIntIterator source, final int skipTheFirstNItems) {
        return new PrimitiveIntFilteringIterator(source){
            private int skipped;
            {
                super(source);
                this.skipped = 0;
            }

            @Override
            public boolean test(int item) {
                if (this.skipped < skipTheFirstNItems) {
                    ++this.skipped;
                    return false;
                }
                return true;
            }
        };
    }

    public static PrimitiveIntIterator limit(final PrimitiveIntIterator source, final int maxItems) {
        return new PrimitiveIntBaseIterator(){
            private int visited;

            @Override
            protected boolean fetchNext() {
                if (this.visited++ < maxItems && source.hasNext()) {
                    return this.next(source.next());
                }
                return false;
            }
        };
    }

    public static PrimitiveIntIterator range(int end) {
        return PrimitiveIntCollections.range(0, end);
    }

    public static PrimitiveIntIterator range(int start, int end) {
        return PrimitiveIntCollections.range(start, end, 1);
    }

    public static PrimitiveIntIterator range(int start, int end, int stride) {
        return new PrimitiveIntRangeIterator(start, end, stride);
    }

    public static PrimitiveIntIterator singleton(final int item) {
        return new PrimitiveIntBaseIterator(){
            private boolean returned;

            @Override
            protected boolean fetchNext() {
                try {
                    boolean bl = !this.returned ? this.next(item) : false;
                    return bl;
                }
                finally {
                    this.returned = true;
                }
            }
        };
    }

    public static int first(PrimitiveIntIterator iterator2) {
        PrimitiveIntCollections.assertMoreItems(iterator2);
        return iterator2.next();
    }

    private static void assertMoreItems(PrimitiveIntIterator iterator2) {
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException("No element in " + iterator2);
        }
    }

    public static int first(PrimitiveIntIterator iterator2, int defaultItem) {
        return iterator2.hasNext() ? iterator2.next() : defaultItem;
    }

    public static int last(PrimitiveIntIterator iterator2) {
        PrimitiveIntCollections.assertMoreItems(iterator2);
        return PrimitiveIntCollections.last(iterator2, 0);
    }

    public static int last(PrimitiveIntIterator iterator2, int defaultItem) {
        int result2 = defaultItem;
        while (iterator2.hasNext()) {
            result2 = iterator2.next();
        }
        return result2;
    }

    public static int single(PrimitiveIntIterator iterator2) {
        try {
            PrimitiveIntCollections.assertMoreItems(iterator2);
            int item = iterator2.next();
            if (iterator2.hasNext()) {
                throw new NoSuchElementException("More than one item in " + iterator2 + ", first:" + item + ", second:" + iterator2.next());
            }
            PrimitiveCommons.closeSafely(iterator2);
            return item;
        }
        catch (NoSuchElementException exception) {
            PrimitiveCommons.closeSafely(iterator2, exception);
            throw exception;
        }
    }

    public static int single(PrimitiveIntIterator iterator2, int defaultItem) {
        try {
            if (!iterator2.hasNext()) {
                PrimitiveCommons.closeSafely(iterator2);
                return defaultItem;
            }
            int item = iterator2.next();
            if (iterator2.hasNext()) {
                throw new NoSuchElementException("More than one item in " + iterator2 + ", first:" + item + ", second:" + iterator2.next());
            }
            PrimitiveCommons.closeSafely(iterator2);
            return item;
        }
        catch (NoSuchElementException exception) {
            PrimitiveCommons.closeSafely(iterator2, exception);
            throw exception;
        }
    }

    public static int itemAt(PrimitiveIntIterator iterator2, int index) {
        if (index >= 0) {
            for (int i = 0; iterator2.hasNext() && i < index; ++i) {
                iterator2.next();
            }
            PrimitiveIntCollections.assertMoreItems(iterator2);
            return iterator2.next();
        }
        int fromEnd = index * -1;
        int[] trail = new int[fromEnd];
        int cursor = 0;
        while (iterator2.hasNext()) {
            trail[cursor % trail.length] = iterator2.next();
            ++cursor;
        }
        if (cursor < fromEnd) {
            throw new NoSuchElementException("Item " + index + " not found in " + iterator2);
        }
        return trail[cursor % fromEnd];
    }

    public static int itemAt(PrimitiveIntIterator iterator2, int index, int defaultItem) {
        if (index >= 0) {
            for (int i = 0; iterator2.hasNext() && i < index; ++i) {
                iterator2.next();
            }
            return iterator2.hasNext() ? iterator2.next() : defaultItem;
        }
        int fromEnd = index * -1;
        int[] trail = new int[fromEnd];
        int cursor = 0;
        while (iterator2.hasNext()) {
            trail[cursor % trail.length] = iterator2.next();
            ++cursor;
        }
        return cursor < fromEnd ? defaultItem : trail[cursor % fromEnd];
    }

    public static int indexOf(PrimitiveIntIterator iterator2, int item) {
        int i = 0;
        while (iterator2.hasNext()) {
            if (item == iterator2.next()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean equals(PrimitiveIntIterator first, PrimitiveIntIterator other2) {
        boolean otherHasNext;
        boolean firstHasNext;
        while ((firstHasNext = first.hasNext()) | (otherHasNext = other2.hasNext())) {
            if (firstHasNext == otherHasNext && first.next() == other2.next()) continue;
            return false;
        }
        return true;
    }

    public static PrimitiveIntSet asSet(PrimitiveIntIterator iterator2) {
        PrimitiveIntSet set = Primitive.intSet();
        while (iterator2.hasNext()) {
            int next2 = iterator2.next();
            if (set.add(next2)) continue;
            throw new IllegalStateException("Duplicate " + next2 + " from " + iterator2);
        }
        return set;
    }

    public static PrimitiveIntSet asSetAllowDuplicates(PrimitiveIntIterator iterator2) {
        PrimitiveIntSet set = Primitive.intSet();
        while (iterator2.hasNext()) {
            set.add(iterator2.next());
        }
        return set;
    }

    public static int count(PrimitiveIntIterator iterator2) {
        int count2 = 0;
        while (iterator2.hasNext()) {
            iterator2.next();
            ++count2;
        }
        return count2;
    }

    public static int[] asArray(PrimitiveIntIterator iterator2) {
        int[] array = new int[8];
        int i = 0;
        while (iterator2.hasNext()) {
            if (i >= array.length) {
                array = Arrays.copyOf(array, i << 1);
            }
            array[i] = iterator2.next();
            ++i;
        }
        if (i < array.length) {
            array = Arrays.copyOf(array, i);
        }
        return array;
    }

    public static int[] asArray(Collection<Integer> values2) {
        int[] array = new int[values2.size()];
        int i = 0;
        for (int value : values2) {
            array[i++] = value;
        }
        return array;
    }

    public static PrimitiveIntIterator emptyIterator() {
        return EMPTY;
    }

    public static PrimitiveIntSet emptySet() {
        return Empty.EMPTY_PRIMITIVE_INT_SET;
    }

    public static PrimitiveIntIterator toPrimitiveIterator(final Iterator<Integer> iterator2) {
        return new PrimitiveIntBaseIterator(){

            @Override
            protected boolean fetchNext() {
                if (iterator2.hasNext()) {
                    Integer nextValue = (Integer)iterator2.next();
                    if (null == nextValue) {
                        throw new IllegalArgumentException("Cannot convert null Integer to primitive int");
                    }
                    return this.next(nextValue);
                }
                return false;
            }
        };
    }

    public static PrimitiveIntIterator flatten(final Iterator<PrimitiveIntIterator> source) {
        return new PrimitiveIntBaseIterator(){
            private PrimitiveIntIterator current;

            @Override
            protected boolean fetchNext() {
                while (this.current == null || !this.current.hasNext()) {
                    if (!source.hasNext()) {
                        return false;
                    }
                    this.current = (PrimitiveIntIterator)source.next();
                }
                return source.hasNext() ? this.next(this.current.next()) : false;
            }
        };
    }

    public static <T> Iterator<T> map(final IntFunction<T> mapFunction, final PrimitiveIntIterator source) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return source.hasNext();
            }

            @Override
            public T next() {
                return mapFunction.apply(source.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static PrimitiveIntIterator constant(final int value) {
        return new PrimitiveIntBaseIterator(){

            @Override
            protected boolean fetchNext() {
                return this.next(value);
            }
        };
    }

    public static PrimitiveIntSet asSet(int[] values2) {
        PrimitiveIntSet set = Primitive.intSet(values2.length);
        for (int value : values2) {
            set.add(value);
        }
        return set;
    }

    public static boolean contains(int[] values2, int candidate) {
        for (int i = 0; i < values2.length; ++i) {
            if (values2[i] != candidate) continue;
            return true;
        }
        return false;
    }

    public static <C extends Collection<Integer>> C addToCollection(PrimitiveIntIterator iterator2, C collection) {
        while (iterator2.hasNext()) {
            collection.add(iterator2.next());
        }
        return collection;
    }

    public static List<Integer> toList(PrimitiveIntIterator iterator2) {
        ArrayList<Integer> out = new ArrayList<Integer>();
        while (iterator2.hasNext()) {
            out.add(iterator2.next());
        }
        return out;
    }

    public static Set<Integer> toSet(PrimitiveIntIterator iterator2) {
        HashSet<Integer> set = new HashSet<Integer>();
        while (iterator2.hasNext()) {
            PrimitiveIntCollections.addUnique(set, iterator2.next());
        }
        return set;
    }

    private static <T, C extends Collection<T>> void addUnique(C collection, T item) {
        if (!collection.add(item)) {
            throw new IllegalStateException("Encountered an already added item:" + item + " when adding items uniquely to a collection:" + collection);
        }
    }

    public static class PrimitiveIntRangeIterator
    extends PrimitiveIntBaseIterator {
        private int current;
        private final int end;
        private final int stride;

        public PrimitiveIntRangeIterator(int start, int end, int stride) {
            this.current = start;
            this.end = end;
            this.stride = stride;
        }

        @Override
        protected boolean fetchNext() {
            try {
                boolean bl = this.current <= this.end ? this.next(this.current) : false;
                return bl;
            }
            finally {
                this.current += this.stride;
            }
        }
    }

    public static abstract class PrimitiveIntFilteringIterator
    extends PrimitiveIntBaseIterator
    implements IntPredicate {
        private final PrimitiveIntIterator source;

        public PrimitiveIntFilteringIterator(PrimitiveIntIterator source) {
            this.source = source;
        }

        @Override
        protected boolean fetchNext() {
            while (this.source.hasNext()) {
                int testItem = this.source.next();
                if (!this.test(testItem)) continue;
                return this.next(testItem);
            }
            return false;
        }

        @Override
        public abstract boolean test(int var1);
    }

    public static class PrimitiveIntInterleavingIterator
    extends PrimitiveIntBaseIterator {
        private final Iterable<PrimitiveIntIterator> iterators;
        private Iterator<PrimitiveIntIterator> currentRound;

        public PrimitiveIntInterleavingIterator(Iterable<PrimitiveIntIterator> iterators) {
            this.iterators = iterators;
        }

        @Override
        protected boolean fetchNext() {
            if (this.currentRound == null || !this.currentRound.hasNext()) {
                this.currentRound = this.iterators.iterator();
            }
            while (this.currentRound.hasNext()) {
                PrimitiveIntIterator iterator2 = this.currentRound.next();
                if (!iterator2.hasNext()) continue;
                return this.next(iterator2.next());
            }
            this.currentRound = null;
            return false;
        }
    }

    public static class PrimitiveIntConcatingIterator
    extends PrimitiveIntBaseIterator {
        private final Iterator<PrimitiveIntIterator> iterators;
        private PrimitiveIntIterator currentIterator;

        public PrimitiveIntConcatingIterator(Iterator<PrimitiveIntIterator> iterators) {
            this.iterators = iterators;
        }

        @Override
        protected boolean fetchNext() {
            if (this.currentIterator == null || !this.currentIterator.hasNext()) {
                while (this.iterators.hasNext()) {
                    this.currentIterator = this.iterators.next();
                    if (!this.currentIterator.hasNext()) continue;
                }
            }
            return this.currentIterator != null && this.currentIterator.hasNext() ? this.next(this.currentIterator.next()) : false;
        }

        protected final PrimitiveIntIterator currentIterator() {
            return this.currentIterator;
        }
    }

    public static abstract class PrimitiveIntBaseIterator
    implements PrimitiveIntIterator {
        private boolean hasNext;
        private int next;

        @Override
        public boolean hasNext() {
            return this.hasNext ? true : (this.hasNext = this.fetchNext());
        }

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements in " + this);
            }
            this.hasNext = false;
            return this.next;
        }

        protected abstract boolean fetchNext();

        protected boolean next(int nextItem) {
            this.next = nextItem;
            this.hasNext = true;
            return true;
        }
    }
}

