/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen.source;

import java.util.Deque;
import java.util.LinkedList;
import org.apache.commons.lang3.StringEscapeUtils;
import org.neo4j.codegen.Expression;
import org.neo4j.codegen.ExpressionVisitor;
import org.neo4j.codegen.FieldReference;
import org.neo4j.codegen.LocalVariable;
import org.neo4j.codegen.MethodEmitter;
import org.neo4j.codegen.MethodReference;
import org.neo4j.codegen.Parameter;
import org.neo4j.codegen.Resource;
import org.neo4j.codegen.TypeReference;
import org.neo4j.codegen.source.ClassWriter;
import org.neo4j.codegen.source.SourceCode;

class MethodWriter
implements MethodEmitter,
ExpressionVisitor {
    private static final Runnable BOTTOM = new Runnable(){

        @Override
        public void run() {
            throw new IllegalStateException("Popped too many levels!");
        }
    };
    private static final Runnable LEVEL = new Runnable(){

        @Override
        public void run() {
        }
    };
    private static final String INDENTATION = "    ";
    private final StringBuilder target;
    private final ClassWriter classWriter;
    private final Deque<Runnable> level = new LinkedList<Runnable>();

    public MethodWriter(StringBuilder target, ClassWriter classWriter) {
        this.target = target;
        this.classWriter = classWriter;
        this.level.push(BOTTOM);
        this.level.push(LEVEL);
    }

    private StringBuilder indent() {
        int level = this.level.size();
        while (level-- > 0) {
            this.target.append(INDENTATION);
        }
        return this.target;
    }

    private StringBuilder append(CharSequence text2) {
        return this.target.append(text2);
    }

    @Override
    public void done() {
        if (this.level.size() != 1) {
            throw new IllegalStateException("unbalanced blocks!");
        }
        this.classWriter.append(this.target);
    }

    @Override
    public void expression(Expression expression) {
        this.indent();
        expression.accept(this);
        this.target.append(";\n");
    }

    @Override
    public void put(Expression target, FieldReference field2, Expression value) {
        this.indent();
        target.accept(this);
        this.append(".");
        this.append(field2.name());
        this.append(" = ");
        value.accept(this);
        this.append(";\n");
    }

    @Override
    public void returns() {
        this.indent().append("return;\n");
    }

    @Override
    public void returns(Expression value) {
        this.indent().append("return ");
        value.accept(this);
        this.append(";\n");
    }

    @Override
    public void declare(LocalVariable local) {
        this.indent().append(local.type().name()).append(' ').append(local.name()).append(";\n");
    }

    @Override
    public void assign(LocalVariable local, Expression value) {
        this.indent().append(local.name()).append(" = ");
        value.accept(this);
        this.append(";\n");
    }

    @Override
    public void beginForEach(Parameter local, Expression iterable) {
        this.indent().append("for ( ").append(local.type().name()).append(" ").append(local.name()).append(" : ");
        iterable.accept(this);
        this.append(" )\n");
        this.indent().append("{\n");
        this.level.push(LEVEL);
    }

    @Override
    public void assign(TypeReference type, String name2, Expression value) {
        this.indent().append(type.name()).append(' ').append(name2).append(" = ");
        value.accept(this);
        this.append(";\n");
    }

    @Override
    public void beginWhile(Expression test2) {
        this.indent().append("while( ");
        test2.accept(this);
        this.append(" )\n");
        this.indent().append("{\n");
        this.level.push(LEVEL);
    }

    @Override
    public void beginIf(Expression test2) {
        this.indent().append("if ( ");
        test2.accept(this);
        this.append(" )\n");
        this.indent().append("{\n");
        this.level.push(LEVEL);
    }

    @Override
    public void beginCatch(Parameter exception) {
        this.indent().append("catch ( ").append(exception.type().name()).append(" ").append(exception.name()).append(" )\n");
        this.indent().append("{\n");
        this.level.push(LEVEL);
    }

    @Override
    public void beginFinally() {
        this.indent().append("finally\n");
        this.indent().append("{\n");
        this.level.push(LEVEL);
    }

    @Override
    public void beginTry(final Resource ... resources) {
        if (resources.length > 0 && this.classWriter.configuration.isSet(SourceCode.SIMPLIFY_TRY_WITH_RESOURCE)) {
            for (Resource resource : resources) {
                this.indent().append(resource.type().name()).append(" ").append(resource.name()).append(" = ");
                resource.producer().accept(this);
                this.append(";\n");
            }
            this.indent().append("try\n");
            this.indent().append("{");
            this.level.push(new Runnable(){

                @Override
                public void run() {
                    MethodWriter.this.beginFinally();
                    for (Resource resource : resources) {
                        MethodWriter.this.indent().append(resource.name()).append(".close();\n");
                    }
                    MethodWriter.this.endBlock();
                }
            });
        } else {
            this.indent().append("try");
            if (resources.length > 0) {
                String sep = " ( ";
                for (Resource resource : resources) {
                    this.append(sep).append(resource.type().name()).append(" ").append(resource.name()).append(" = ");
                    resource.producer().accept(this);
                    sep = "; ";
                }
                this.append(" )");
            }
            this.append("\n");
            this.indent().append("{\n");
            this.level.push(LEVEL);
        }
    }

    @Override
    public void throwException(Expression exception) {
        this.indent().append("throw ");
        exception.accept(this);
        this.append(";\n");
    }

    @Override
    public void endBlock() {
        Runnable action = this.level.pop();
        this.indent().append("}\n");
        action.run();
    }

    @Override
    public void invoke(Expression target, MethodReference method, Expression[] arguments2) {
        target.accept(this);
        if (!method.isConstructor()) {
            this.append(".").append(method.name());
        }
        this.arglist(arguments2);
    }

    @Override
    public void invoke(MethodReference method, Expression[] arguments2) {
        this.append(method.owner().name()).append('.').append(method.name());
        this.arglist(arguments2);
    }

    private void arglist(Expression[] arguments2) {
        this.append("(");
        String sep = " ";
        for (Expression argument : arguments2) {
            this.append(sep);
            argument.accept(this);
            sep = ", ";
        }
        if (sep.length() > 1) {
            this.append(" ");
        }
        this.append(")");
    }

    @Override
    public void load(TypeReference type, String name2) {
        this.append(name2);
    }

    @Override
    public void getField(Expression target, FieldReference field2) {
        target.accept(this);
        this.append(".").append(field2.name());
    }

    @Override
    public void constant(Object value) {
        if (value == null) {
            this.append("null");
        } else if (value instanceof String) {
            this.append("\"").append(StringEscapeUtils.escapeJava((String)value)).append('\"');
        } else if (value instanceof Integer) {
            this.append(value.toString());
        } else if (value instanceof Long) {
            this.append(value.toString()).append('L');
        } else if (value instanceof Double) {
            this.append(value.toString());
        } else if (value instanceof Boolean) {
            this.append(value.toString());
        } else {
            throw new UnsupportedOperationException(value.getClass() + " constants");
        }
    }

    @Override
    public void getStatic(FieldReference field2) {
        this.append(field2.owner().name()).append(".").append(field2.name());
    }

    @Override
    public void loadThis(String sourceName) {
        this.append(sourceName);
    }

    @Override
    public void newInstance(TypeReference type) {
        this.append("new ").append(type.name());
    }

    @Override
    public void not(Expression expression) {
        this.append("!( ");
        expression.accept(this);
        this.append(" )");
    }

    @Override
    public void ternary(Expression test2, Expression onTrue, Expression onFalse) {
        this.append("((");
        test2.accept(this);
        this.append(") ? (");
        onTrue.accept(this);
        this.append(") : (");
        onFalse.accept(this);
        this.append("))");
    }

    @Override
    public void eq(Expression lhs, Expression rhs) {
        lhs.accept(this);
        this.append(" == ");
        rhs.accept(this);
    }

    @Override
    public void or(Expression lhs, Expression rhs) {
        lhs.accept(this);
        this.append(" || ");
        rhs.accept(this);
    }

    @Override
    public void add(Expression lhs, Expression rhs) {
        lhs.accept(this);
        this.append(" + ");
        rhs.accept(this);
    }

    @Override
    public void gt(Expression lhs, Expression rhs) {
        lhs.accept(this);
        this.append(" > ");
        rhs.accept(this);
    }

    @Override
    public void sub(Expression lhs, Expression rhs) {
        lhs.accept(this);
        this.append(" - ");
        rhs.accept(this);
    }

    @Override
    public void cast(TypeReference type, Expression expression) {
        this.append("(").append(type.name()).append(") ");
        expression.accept(this);
    }
}

