/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import java.util.Arrays;

public class TypeReference {
    private final String packageName;
    private final String simpleName;
    private final TypeReference[] parameters;
    static final TypeReference VOID = new TypeReference("", "void", new TypeReference[0]);
    static final TypeReference OBJECT = new TypeReference("java.lang", "Object", new TypeReference[0]);
    static final TypeReference[] NO_TYPES = new TypeReference[0];

    public static Bound extending(Class<?> type) {
        return TypeReference.extending(TypeReference.typeReference(type));
    }

    public static Bound extending(final TypeReference type) {
        return new Bound(type){

            @Override
            public TypeReference extendsBound() {
                return type;
            }

            @Override
            public TypeReference superBound() {
                return null;
            }
        };
    }

    public static TypeReference typeReference(Class<?> type) {
        String simpleName;
        if (type == Void.TYPE) {
            return VOID;
        }
        if (type == Object.class) {
            return OBJECT;
        }
        String packageName = "";
        if (type.isArray()) {
            simpleName = type.getComponentType().getCanonicalName() + "[]";
        } else if (type.isPrimitive()) {
            simpleName = type.getName();
        } else {
            packageName = type.getPackage().getName();
            String canonicalName = type.getCanonicalName();
            simpleName = canonicalName.substring(packageName.length() + 1);
        }
        return new TypeReference(packageName, simpleName, new TypeReference[0]);
    }

    public static TypeReference typeParameter(String name2) {
        return new TypeReference("", name2, new TypeReference[0]);
    }

    public static TypeReference parameterizedType(Class<?> base, Class<?> ... parameters) {
        return TypeReference.parameterizedType(TypeReference.typeReference(base), TypeReference.typeReferences(parameters));
    }

    public static TypeReference parameterizedType(Class<?> base, TypeReference ... parameters) {
        return TypeReference.parameterizedType(TypeReference.typeReference(base), parameters);
    }

    public static TypeReference parameterizedType(TypeReference base, TypeReference ... parameters) {
        return new TypeReference(base.packageName, base.simpleName, parameters);
    }

    public static TypeReference[] typeReferences(Class<?> first, Class<?>[] more) {
        TypeReference[] result2 = new TypeReference[more.length + 1];
        result2[0] = TypeReference.typeReference(first);
        for (int i = 0; i < more.length; ++i) {
            result2[i + 1] = TypeReference.typeReference(more[i]);
        }
        return result2;
    }

    public static TypeReference[] typeReferences(Class<?>[] types2) {
        TypeReference[] result2 = new TypeReference[types2.length];
        for (int i = 0; i < result2.length; ++i) {
            result2[i] = TypeReference.typeReference(types2[i]);
        }
        return result2;
    }

    public String packageName() {
        return this.packageName;
    }

    public String simpleName() {
        return this.simpleName;
    }

    TypeReference(String packageName, String simpleName, TypeReference ... parameters) {
        this.packageName = packageName;
        this.simpleName = simpleName;
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeReference)) {
            return false;
        }
        TypeReference that = (TypeReference)o;
        return this.simpleName.equals(that.simpleName) && this.packageName.equals(that.packageName) && Arrays.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        int result2 = this.packageName.hashCode();
        result2 = 31 * result2 + this.simpleName.hashCode();
        result2 = 31 * result2 + Arrays.hashCode(this.parameters);
        return result2;
    }

    public String toString() {
        return this.writeTo(new StringBuilder().append("TypeReference[")).append(']').toString();
    }

    StringBuilder writeTo(StringBuilder result2) {
        if (!this.packageName.isEmpty()) {
            result2.append(this.packageName).append('.');
        }
        result2.append(this.simpleName);
        if (this.parameters != null && this.parameters.length != 0) {
            result2.append('<');
            String sep = "";
            for (TypeReference parameter : this.parameters) {
                parameter.writeTo(result2.append(sep));
                sep = ",";
            }
            result2.append('>');
        }
        return result2;
    }

    public String name() {
        return this.writeTo(new StringBuilder()).toString();
    }

    public static abstract class Bound {
        private final TypeReference type;

        private Bound(TypeReference type) {
            this.type = type;
        }

        public abstract TypeReference extendsBound();

        public abstract TypeReference superBound();
    }
}

