/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import java.util.Objects;
import org.neo4j.codegen.TypeReference;

public class Parameter {
    static final Parameter[] NO_PARAMETERS = new Parameter[0];
    private final TypeReference type;
    private final String name;

    public static Parameter param(Class<?> type, String name2) {
        return Parameter.param(TypeReference.typeReference(type), name2);
    }

    public static Parameter param(TypeReference type, String name2) {
        return new Parameter(Objects.requireNonNull(type, "TypeReference"), Parameter.requireValidName(name2));
    }

    private Parameter(TypeReference type, String name2) {
        if (type == TypeReference.VOID) {
            throw new IllegalArgumentException("Variables cannot be declared as void.");
        }
        this.type = type;
        this.name = name2;
    }

    public String toString() {
        return this.writeTo(new StringBuilder()).toString();
    }

    StringBuilder writeTo(StringBuilder result2) {
        result2.append("Parameter[ ");
        this.type.writeTo(result2);
        return result2.append(" ").append(this.name).append(" ]");
    }

    public TypeReference type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    static String requireValidName(String name2) {
        int cp;
        if (name2 == null) {
            throw new NullPointerException("name");
        }
        Parameter.notKeyword(name2);
        if (!Character.isJavaIdentifierStart(name2.codePointAt(0))) {
            throw new IllegalArgumentException("Invalid name: " + name2);
        }
        for (int i = 0; i < name2.length(); i += Character.charCount(cp)) {
            cp = name2.codePointAt(i);
            if (Character.isJavaIdentifierPart(cp)) continue;
            throw new IllegalArgumentException("Invalid name: " + name2);
        }
        return name2;
    }

    private static void notKeyword(String name2) {
        switch (name2) {
            case "abstract": 
            case "continue": 
            case "for": 
            case "new": 
            case "switch": 
            case "assert": 
            case "default": 
            case "goto": 
            case "package": 
            case "synchronized": 
            case "boolean": 
            case "do": 
            case "if": 
            case "private": 
            case "break": 
            case "double": 
            case "implements": 
            case "protected": 
            case "throw": 
            case "byte": 
            case "else": 
            case "import": 
            case "public": 
            case "throws": 
            case "case": 
            case "enum": 
            case "instanceof": 
            case "return": 
            case "transient": 
            case "catch": 
            case "extends": 
            case "int": 
            case "short": 
            case "try": 
            case "char": 
            case "final": 
            case "interface": 
            case "static": 
            case "void": 
            case "class": 
            case "finally": 
            case "long": 
            case "strictfp": 
            case "volatile": 
            case "const": 
            case "float": 
            case "native": 
            case "super": 
            case "while": {
                throw new IllegalArgumentException("'" + name2 + "' is a java keyword");
            }
            case "this": 
            case "null": 
            case "true": 
            case "false": {
                throw new IllegalArgumentException("'" + name2 + "' is a reserved name");
            }
        }
    }

    boolean isVarArg() {
        return false;
    }
}

