/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import org.neo4j.codegen.CodeBlock;
import org.neo4j.codegen.ExpressionTemplate;
import org.neo4j.codegen.ExpressionToString;
import org.neo4j.codegen.ExpressionVisitor;
import org.neo4j.codegen.FieldReference;
import org.neo4j.codegen.MethodReference;
import org.neo4j.codegen.TypeReference;

public abstract class Expression
extends ExpressionTemplate {
    static final Expression SUPER = new Expression(){

        @Override
        public void accept(ExpressionVisitor visitor) {
            visitor.loadThis("super");
        }
    };

    public abstract void accept(ExpressionVisitor var1);

    public static Expression gt(final Expression lhs, final Expression rhs) {
        return new Expression(){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.gt(lhs, rhs);
            }
        };
    }

    public static Expression or(final Expression lhs, final Expression rhs) {
        return new Expression(){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.or(lhs, rhs);
            }
        };
    }

    public static Expression eq(final Expression lhs, final Expression rhs) {
        return new Expression(){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.eq(lhs, rhs);
            }
        };
    }

    static Expression load(final TypeReference type, final String name2) {
        return new Expression(){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.load(type, name2);
            }
        };
    }

    public static Expression add(final Expression lhs, final Expression rhs) {
        return new Expression(){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.add(lhs, rhs);
            }
        };
    }

    public static Expression sub(final Expression lhs, final Expression rhs) {
        return new Expression(){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.sub(lhs, rhs);
            }
        };
    }

    public static Expression constant(final Object value) {
        if (!(value == null || value instanceof String || value instanceof Long || value instanceof Integer || value instanceof Double || value instanceof Boolean)) {
            throw new IllegalArgumentException("Not a valid constant!");
        }
        return new Expression(){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.constant(value);
            }
        };
    }

    public static Expression get(final Expression target, final FieldReference field2) {
        return new Expression(){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.getField(target, field2);
            }
        };
    }

    public static Expression get(final FieldReference field2) {
        return new Expression(){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.getStatic(field2);
            }
        };
    }

    public static Expression ternary(final Expression test2, final Expression onTrue, final Expression onFalse) {
        return new Expression(){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.ternary(test2, onTrue, onFalse);
            }
        };
    }

    public static Expression invoke(final Expression target, final MethodReference method, final Expression ... arguments2) {
        return new Expression(){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.invoke(target, method, arguments2);
            }
        };
    }

    public static Expression invoke(final MethodReference method, final Expression ... parameters) {
        return new Expression(){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.invoke(method, parameters);
            }
        };
    }

    public static Expression cast(Class<?> type, Expression expression) {
        return Expression.cast(TypeReference.typeReference(type), expression);
    }

    public static Expression cast(final TypeReference type, final Expression expression) {
        return new Expression(){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.cast(type, expression);
            }
        };
    }

    public static Expression newInstance(Class<?> type) {
        return Expression.newInstance(TypeReference.typeReference(type));
    }

    public static Expression newInstance(final TypeReference type) {
        return new Expression(){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.newInstance(type);
            }
        };
    }

    public static Expression not(final Expression expression) {
        return new Expression(){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.not(expression);
            }
        };
    }

    @Override
    Expression materialize(CodeBlock method) {
        return this;
    }

    @Override
    void templateAccept(CodeBlock method, ExpressionVisitor visitor) {
        throw new UnsupportedOperationException("simple expressions should not be invoked as templates");
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder().append("Expression[");
        this.accept(new ExpressionToString(result2));
        return result2.append(']').toString();
    }
}

