/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import java.util.Objects;
import org.neo4j.codegen.ByteCodeVisitor;
import org.neo4j.codegen.ByteCodes;
import org.neo4j.codegen.ClassEmitter;
import org.neo4j.codegen.ClassGenerator;
import org.neo4j.codegen.ClassHandle;
import org.neo4j.codegen.CodeGenerationNotSupportedException;
import org.neo4j.codegen.CodeGenerationStrategy;
import org.neo4j.codegen.CodeGeneratorOption;
import org.neo4j.codegen.CodeLoader;
import org.neo4j.codegen.CompilationFailureException;
import org.neo4j.codegen.TypeReference;

public abstract class CodeGenerator {
    private final CodeLoader loader;
    private long generation;
    private long classes;
    private ByteCodeVisitor byteCodeVisitor = ByteCodeVisitor.DO_NOTHING;

    public static CodeGenerator generateCode(CodeGeneratorOption ... options) throws CodeGenerationNotSupportedException {
        return CodeGenerator.generateCode(Thread.currentThread().getContextClassLoader(), options);
    }

    public static CodeGenerator generateCode(ClassLoader loader, CodeGeneratorOption ... options) throws CodeGenerationNotSupportedException {
        return CodeGenerationStrategy.codeGenerator(Objects.requireNonNull(loader, "ClassLoader"), options);
    }

    public CodeGenerator(ClassLoader loader) {
        this.loader = new CodeLoader(loader);
    }

    public ClassGenerator generateClass(String packageName, String name2, Class<?> firstInterface, Class<?> ... more) {
        return this.generateClass(packageName, name2, TypeReference.typeReferences(firstInterface, more));
    }

    public ClassGenerator generateClass(Class<?> base, String packageName, String name2, Class<?> ... interfaces) {
        return this.generateClass(TypeReference.typeReference(base), packageName, name2, TypeReference.typeReferences(interfaces));
    }

    public ClassGenerator generateClass(String packageName, String name2, TypeReference ... interfaces) {
        return this.generateClass(TypeReference.OBJECT, packageName, name2, interfaces);
    }

    public ClassGenerator generateClass(TypeReference base, String packageName, String name2, TypeReference ... interfaces) {
        return this.generateClass(this.makeHandle(packageName, name2, base), base, interfaces);
    }

    private synchronized ClassHandle makeHandle(String packageName, String name2, TypeReference parent2) {
        ++this.classes;
        return new ClassHandle(packageName, name2, parent2, this, this.generation);
    }

    private ClassGenerator generateClass(ClassHandle handle, TypeReference base, TypeReference ... interfaces) {
        return new ClassGenerator(handle, this.generate(handle, base, interfaces));
    }

    protected abstract ClassEmitter generate(TypeReference var1, TypeReference var2, TypeReference ... var3);

    protected abstract Iterable<? extends ByteCodes> compile(ClassLoader var1) throws CompilationFailureException;

    synchronized Class<?> loadClass(String name2, long generation) throws CompilationFailureException {
        if (generation == this.generation) {
            if (this.classes != 0L) {
                throw new IllegalStateException("Compilation has not completed.");
            }
            ++this.generation;
            this.loader.addSources(this.compile(this.loader.getParent()), this.byteCodeVisitor);
        }
        try {
            return this.loader.loadClass(name2);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Could not find defined class.", e);
        }
    }

    synchronized void closeClass() {
        --this.classes;
    }

    void setByteCodeVisitor(ByteCodeVisitor visitor) {
        this.byteCodeVisitor = visitor;
    }
}

