/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.neo4j.codegen.Binding;
import org.neo4j.codegen.ClassEmitter;
import org.neo4j.codegen.ClassHandle;
import org.neo4j.codegen.CodeBlock;
import org.neo4j.codegen.Expression;
import org.neo4j.codegen.FieldReference;
import org.neo4j.codegen.InvalidState;
import org.neo4j.codegen.MethodDeclaration;
import org.neo4j.codegen.MethodReference;
import org.neo4j.codegen.MethodTemplate;
import org.neo4j.codegen.Parameter;
import org.neo4j.codegen.TypeReference;

public class ClassGenerator
implements AutoCloseable {
    private final ClassHandle handle;
    private ClassEmitter emitter;
    private Map<String, FieldReference> fields;

    ClassGenerator(ClassHandle handle, ClassEmitter emitter) {
        this.handle = handle;
        this.emitter = emitter;
    }

    @Override
    public void close() {
        this.emitter.done();
        this.handle.generator.closeClass();
        this.emitter = InvalidState.CLASS_DONE;
    }

    public ClassHandle handle() {
        return this.handle;
    }

    public FieldReference field(Class<?> type, String name2) {
        return this.field(TypeReference.typeReference(type), name2);
    }

    public FieldReference field(TypeReference type, String name2) {
        return this.emitField(1, type, name2, null);
    }

    public FieldReference staticField(Class<?> type, String name2, Expression value) {
        return this.staticField(TypeReference.typeReference(type), name2, value);
    }

    public FieldReference staticField(TypeReference type, String name2) {
        return this.emitField(9, type, name2, null);
    }

    public FieldReference staticField(TypeReference type, String name2, Expression value) {
        return this.emitField(26, type, name2, Objects.requireNonNull(value));
    }

    private FieldReference emitField(int modifiers, TypeReference type, String name2, Expression value) {
        if (this.fields == null) {
            this.fields = new HashMap<String, FieldReference>();
        } else if (this.fields.containsKey(name2)) {
            throw new IllegalArgumentException(this.handle + " already has a field '" + name2 + "'");
        }
        FieldReference field2 = new FieldReference(modifiers, this.handle, type, name2);
        this.fields.put(name2, field2);
        this.emitter.field(field2, value);
        return field2;
    }

    public MethodReference generate(MethodTemplate template, Binding ... bindings) {
        try (CodeBlock generator = this.generate(template.declaration(this.handle));){
            template.generate(generator);
        }
        return MethodReference.methodReference(this.handle, template.returnType(), template.name(), template.parameterTypes());
    }

    public CodeBlock generateConstructor(Parameter ... parameters) {
        return this.generate(MethodDeclaration.constructor(this.handle, parameters, TypeReference.NO_TYPES, MethodDeclaration.TypeParameter.NO_PARAMETERS));
    }

    public CodeBlock generateMethod(Class<?> returnType, String name2, Parameter ... parameters) {
        return this.generateMethod(TypeReference.typeReference(returnType), name2, parameters);
    }

    public CodeBlock generateMethod(TypeReference returnType, String name2, Parameter ... parameters) {
        return this.generate(MethodDeclaration.method((TypeReference)this.handle, returnType, name2, parameters, TypeReference.NO_TYPES, MethodDeclaration.TypeParameter.NO_PARAMETERS));
    }

    public CodeBlock generate(MethodDeclaration.Builder builder) {
        return this.generate(builder.build(this.handle));
    }

    private CodeBlock generate(MethodDeclaration declaration) {
        return new CodeBlock(this, this.emitter.method(declaration));
    }

    FieldReference getField(String name2) {
        return this.fields == null ? null : this.fields.get(name2);
    }
}

