/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import org.apache.lucene.store.DataInput;

public final class PackedDataInput {
    final DataInput in;
    long current;
    int remainingBits;

    public PackedDataInput(DataInput in2) {
        this.in = in2;
        this.skipToNextByte();
    }

    public long readLong(int bitsPerValue) throws IOException {
        assert (bitsPerValue > 0 && bitsPerValue <= 64) : bitsPerValue;
        long r = 0L;
        while (bitsPerValue > 0) {
            if (this.remainingBits == 0) {
                this.current = this.in.readByte() & 0xFF;
                this.remainingBits = 8;
            }
            int bits2 = Math.min(bitsPerValue, this.remainingBits);
            r = r << bits2 | this.current >>> this.remainingBits - bits2 & (1L << bits2) - 1L;
            bitsPerValue -= bits2;
            this.remainingBits -= bits2;
        }
        return r;
    }

    public void skipToNextByte() {
        this.remainingBits = 0;
    }
}

