/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

public class MonotonicBlockPackedReader
extends LongValues
implements Accountable {
    final int blockShift;
    final int blockMask;
    final long valueCount;
    final long[] minValues;
    final float[] averages;
    final PackedInts.Reader[] subReaders;
    final long sumBPV;

    static long expected(long origin, float average, int index) {
        return origin + (long)(average * (float)index);
    }

    public static MonotonicBlockPackedReader of(IndexInput in2, int packedIntsVersion, int blockSize, long valueCount, boolean direct) throws IOException {
        if (packedIntsVersion < 2) {
            return new MonotonicBlockPackedReader(in2, packedIntsVersion, blockSize, valueCount, direct){

                @Override
                protected long decodeDelta(long delta) {
                    return BitUtil.zigZagDecode(delta);
                }
            };
        }
        return new MonotonicBlockPackedReader(in2, packedIntsVersion, blockSize, valueCount, direct);
    }

    private MonotonicBlockPackedReader(IndexInput in2, int packedIntsVersion, int blockSize, long valueCount, boolean direct) throws IOException {
        this.valueCount = valueCount;
        this.blockShift = PackedInts.checkBlockSize(blockSize, 64, 0x8000000);
        this.blockMask = blockSize - 1;
        int numBlocks = PackedInts.numBlocks(valueCount, blockSize);
        this.minValues = new long[numBlocks];
        this.averages = new float[numBlocks];
        this.subReaders = new PackedInts.Reader[numBlocks];
        long sumBPV = 0L;
        for (int i = 0; i < numBlocks; ++i) {
            this.minValues[i] = packedIntsVersion < 2 ? in2.readVLong() : in2.readZLong();
            this.averages[i] = Float.intBitsToFloat(in2.readInt());
            int bitsPerValue = in2.readVInt();
            sumBPV += (long)bitsPerValue;
            if (bitsPerValue > 64) {
                throw new IOException("Corrupted");
            }
            if (bitsPerValue == 0) {
                this.subReaders[i] = new PackedInts.NullReader(blockSize);
                continue;
            }
            int size2 = (int)Math.min((long)blockSize, valueCount - (long)i * (long)blockSize);
            if (direct) {
                long pointer = in2.getFilePointer();
                this.subReaders[i] = PackedInts.getDirectReaderNoHeader(in2, PackedInts.Format.PACKED, packedIntsVersion, size2, bitsPerValue);
                in2.seek(pointer + PackedInts.Format.PACKED.byteCount(packedIntsVersion, size2, bitsPerValue));
                continue;
            }
            this.subReaders[i] = PackedInts.getReaderNoHeader(in2, PackedInts.Format.PACKED, packedIntsVersion, size2, bitsPerValue);
        }
        this.sumBPV = sumBPV;
    }

    @Override
    public long get(long index) {
        assert (index >= 0L && index < this.valueCount);
        int block = (int)(index >>> this.blockShift);
        int idx = (int)(index & (long)this.blockMask);
        return MonotonicBlockPackedReader.expected(this.minValues[block], this.averages[block], idx) + this.decodeDelta(this.subReaders[block].get(idx));
    }

    protected long decodeDelta(long delta) {
        return delta;
    }

    public long size() {
        return this.valueCount;
    }

    @Override
    public long ramBytesUsed() {
        long sizeInBytes = 0L;
        sizeInBytes += RamUsageEstimator.sizeOf(this.minValues);
        sizeInBytes += RamUsageEstimator.sizeOf(this.averages);
        for (PackedInts.Reader reader : this.subReaders) {
            sizeInBytes += reader.ramBytesUsed();
        }
        return sizeInBytes;
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    public String toString() {
        long avgBPV = this.subReaders.length == 0 ? 0L : this.sumBPV / (long)this.subReaders.length;
        return this.getClass().getSimpleName() + "(blocksize=" + (1 << this.blockShift) + ",size=" + this.valueCount + ",avgBPV=" + avgBPV + ")";
    }
}

