/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.LongsRef;
import org.apache.lucene.util.packed.PackedInts;

public final class BlockPackedReaderIterator {
    DataInput in;
    final int packedIntsVersion;
    long valueCount;
    final int blockSize;
    final long[] values;
    final LongsRef valuesRef;
    byte[] blocks;
    int off;
    long ord;

    static long readVLong(DataInput in2) throws IOException {
        byte b = in2.readByte();
        if (b >= 0) {
            return b;
        }
        long i = (long)b & 0x7FL;
        b = in2.readByte();
        i |= ((long)b & 0x7FL) << 7;
        if (b >= 0) {
            return i;
        }
        b = in2.readByte();
        i |= ((long)b & 0x7FL) << 14;
        if (b >= 0) {
            return i;
        }
        b = in2.readByte();
        i |= ((long)b & 0x7FL) << 21;
        if (b >= 0) {
            return i;
        }
        b = in2.readByte();
        i |= ((long)b & 0x7FL) << 28;
        if (b >= 0) {
            return i;
        }
        b = in2.readByte();
        i |= ((long)b & 0x7FL) << 35;
        if (b >= 0) {
            return i;
        }
        b = in2.readByte();
        i |= ((long)b & 0x7FL) << 42;
        if (b >= 0) {
            return i;
        }
        b = in2.readByte();
        i |= ((long)b & 0x7FL) << 49;
        if (b >= 0) {
            return i;
        }
        b = in2.readByte();
        return i |= ((long)b & 0xFFL) << 56;
    }

    public BlockPackedReaderIterator(DataInput in2, int packedIntsVersion, int blockSize, long valueCount) {
        PackedInts.checkBlockSize(blockSize, 64, 0x8000000);
        this.packedIntsVersion = packedIntsVersion;
        this.blockSize = blockSize;
        this.values = new long[blockSize];
        this.valuesRef = new LongsRef(this.values, 0, 0);
        this.reset(in2, valueCount);
    }

    public void reset(DataInput in2, long valueCount) {
        this.in = in2;
        assert (valueCount >= 0L);
        this.valueCount = valueCount;
        this.off = this.blockSize;
        this.ord = 0L;
    }

    public void skip(long count2) throws IOException {
        assert (count2 >= 0L);
        if (this.ord + count2 > this.valueCount || this.ord + count2 < 0L) {
            throw new EOFException();
        }
        int skipBuffer = (int)Math.min(count2, (long)(this.blockSize - this.off));
        this.off += skipBuffer;
        this.ord += (long)skipBuffer;
        if ((count2 -= (long)skipBuffer) == 0L) {
            return;
        }
        assert (this.off == this.blockSize);
        while (count2 >= (long)this.blockSize) {
            int token = this.in.readByte() & 0xFF;
            int bitsPerValue = token >>> 1;
            if (bitsPerValue > 64) {
                throw new IOException("Corrupted");
            }
            if ((token & 1) == 0) {
                BlockPackedReaderIterator.readVLong(this.in);
            }
            long blockBytes = PackedInts.Format.PACKED.byteCount(this.packedIntsVersion, this.blockSize, bitsPerValue);
            this.skipBytes(blockBytes);
            this.ord += (long)this.blockSize;
            count2 -= (long)this.blockSize;
        }
        if (count2 == 0L) {
            return;
        }
        assert (count2 < (long)this.blockSize);
        this.refill();
        this.ord += count2;
        this.off = (int)((long)this.off + count2);
    }

    private void skipBytes(long count2) throws IOException {
        if (this.in instanceof IndexInput) {
            IndexInput iin = (IndexInput)this.in;
            iin.seek(iin.getFilePointer() + count2);
        } else {
            int toSkip;
            if (this.blocks == null) {
                this.blocks = new byte[this.blockSize];
            }
            for (long skipped = 0L; skipped < count2; skipped += (long)toSkip) {
                toSkip = (int)Math.min((long)this.blocks.length, count2 - skipped);
                this.in.readBytes(this.blocks, 0, toSkip);
            }
        }
    }

    public long next() throws IOException {
        if (this.ord == this.valueCount) {
            throw new EOFException();
        }
        if (this.off == this.blockSize) {
            this.refill();
        }
        long value = this.values[this.off++];
        ++this.ord;
        return value;
    }

    public LongsRef next(int count2) throws IOException {
        assert (count2 > 0);
        if (this.ord == this.valueCount) {
            throw new EOFException();
        }
        if (this.off == this.blockSize) {
            this.refill();
        }
        count2 = Math.min(count2, this.blockSize - this.off);
        count2 = (int)Math.min((long)count2, this.valueCount - this.ord);
        this.valuesRef.offset = this.off;
        this.valuesRef.length = count2;
        this.off += count2;
        this.ord += (long)count2;
        return this.valuesRef;
    }

    private void refill() throws IOException {
        long minValue;
        int token = this.in.readByte() & 0xFF;
        boolean minEquals0 = (token & 1) != 0;
        int bitsPerValue = token >>> 1;
        if (bitsPerValue > 64) {
            throw new IOException("Corrupted");
        }
        long l = minValue = minEquals0 ? 0L : BitUtil.zigZagDecode(1L + BlockPackedReaderIterator.readVLong(this.in));
        assert (minEquals0 || minValue != 0L);
        if (bitsPerValue == 0) {
            Arrays.fill(this.values, minValue);
        } else {
            PackedInts.Decoder decoder = PackedInts.getDecoder(PackedInts.Format.PACKED, this.packedIntsVersion, bitsPerValue);
            int iterations = this.blockSize / decoder.byteValueCount();
            int blocksSize = iterations * decoder.byteBlockCount();
            if (this.blocks == null || this.blocks.length < blocksSize) {
                this.blocks = new byte[blocksSize];
            }
            int valueCount = (int)Math.min(this.valueCount - this.ord, (long)this.blockSize);
            int blocksCount = (int)PackedInts.Format.PACKED.byteCount(this.packedIntsVersion, valueCount, bitsPerValue);
            this.in.readBytes(this.blocks, 0, blocksCount);
            decoder.decode(this.blocks, 0, this.values, 0, iterations);
            if (minValue != 0L) {
                int i = 0;
                while (i < valueCount) {
                    int n = i++;
                    this.values[n] = this.values[n] + minValue;
                }
            }
        }
        this.off = 0;
    }

    public long ord() {
        return this.ord;
    }
}

