/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.packed.BlockPackedReaderIterator;
import org.apache.lucene.util.packed.PackedInts;

public final class BlockPackedReader
extends LongValues
implements Accountable {
    private final int blockShift;
    private final int blockMask;
    private final long valueCount;
    private final long[] minValues;
    private final PackedInts.Reader[] subReaders;
    private final long sumBPV;

    public BlockPackedReader(IndexInput in2, int packedIntsVersion, int blockSize, long valueCount, boolean direct) throws IOException {
        this.valueCount = valueCount;
        this.blockShift = PackedInts.checkBlockSize(blockSize, 64, 0x8000000);
        this.blockMask = blockSize - 1;
        int numBlocks = PackedInts.numBlocks(valueCount, blockSize);
        long[] minValues = null;
        this.subReaders = new PackedInts.Reader[numBlocks];
        long sumBPV = 0L;
        for (int i = 0; i < numBlocks; ++i) {
            int token = in2.readByte() & 0xFF;
            int bitsPerValue = token >>> 1;
            sumBPV += (long)bitsPerValue;
            if (bitsPerValue > 64) {
                throw new IOException("Corrupted");
            }
            if ((token & 1) == 0) {
                if (minValues == null) {
                    minValues = new long[numBlocks];
                }
                minValues[i] = BitUtil.zigZagDecode(1L + BlockPackedReaderIterator.readVLong(in2));
            }
            if (bitsPerValue == 0) {
                this.subReaders[i] = new PackedInts.NullReader(blockSize);
                continue;
            }
            int size2 = (int)Math.min((long)blockSize, valueCount - (long)i * (long)blockSize);
            if (direct) {
                long pointer = in2.getFilePointer();
                this.subReaders[i] = PackedInts.getDirectReaderNoHeader(in2, PackedInts.Format.PACKED, packedIntsVersion, size2, bitsPerValue);
                in2.seek(pointer + PackedInts.Format.PACKED.byteCount(packedIntsVersion, size2, bitsPerValue));
                continue;
            }
            this.subReaders[i] = PackedInts.getReaderNoHeader(in2, PackedInts.Format.PACKED, packedIntsVersion, size2, bitsPerValue);
        }
        this.minValues = minValues;
        this.sumBPV = sumBPV;
    }

    @Override
    public long get(long index) {
        assert (index >= 0L && index < this.valueCount);
        int block = (int)(index >>> this.blockShift);
        int idx = (int)(index & (long)this.blockMask);
        return (this.minValues == null ? 0L : this.minValues[block]) + this.subReaders[block].get(idx);
    }

    @Override
    public long ramBytesUsed() {
        long size2 = 0L;
        for (PackedInts.Reader reader : this.subReaders) {
            size2 += reader.ramBytesUsed();
        }
        return size2;
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    public String toString() {
        long avgBPV = this.subReaders.length == 0 ? 0L : this.sumBPV / (long)this.subReaders.length;
        return this.getClass().getSimpleName() + "(blocksize=" + (1 << this.blockShift) + ",size=" + this.valueCount + ",avgBPV=" + avgBPV + ")";
    }
}

