/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import java.util.BitSet;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Transition;

public class FiniteStringsIterator {
    private static final IntsRef EMPTY = new IntsRef();
    private final Automaton a;
    private final BitSet pathStates;
    private final IntsRefBuilder string;
    private PathNode[] nodes;
    private boolean emitEmptyString;

    public FiniteStringsIterator(Automaton a) {
        this.a = a;
        this.nodes = new PathNode[16];
        int end = this.nodes.length;
        for (int i = 0; i < end; ++i) {
            this.nodes[i] = new PathNode();
        }
        this.string = new IntsRefBuilder();
        this.pathStates = new BitSet(a.getNumStates());
        this.string.setLength(0);
        this.emitEmptyString = a.isAccept(0);
        if (a.getNumTransitions(0) > 0) {
            this.pathStates.set(0);
            this.nodes[0].resetState(a, 0);
            this.string.append(0);
        }
    }

    public IntsRef next() {
        if (this.emitEmptyString) {
            this.emitEmptyString = false;
            return EMPTY;
        }
        int depth = this.string.length();
        while (depth > 0) {
            PathNode node = this.nodes[depth - 1];
            int label = node.nextLabel(this.a);
            if (label != -1) {
                this.string.setIntAt(depth - 1, label);
                int to2 = node.to;
                if (this.a.getNumTransitions(to2) != 0) {
                    if (this.pathStates.get(to2)) {
                        throw new IllegalArgumentException("automaton has cycles");
                    }
                    this.pathStates.set(to2);
                    this.growStack(depth);
                    this.nodes[depth].resetState(this.a, to2);
                    this.string.setLength(++depth);
                    this.string.grow(depth);
                    continue;
                }
                if (!this.a.isAccept(to2)) continue;
                return this.string.get();
            }
            int state = node.state;
            assert (this.pathStates.get(state));
            this.pathStates.clear(state);
            this.string.setLength(--depth);
            if (!this.a.isAccept(state)) continue;
            return this.string.get();
        }
        return null;
    }

    private void growStack(int depth) {
        if (this.nodes.length == depth) {
            PathNode[] newNodes = new PathNode[ArrayUtil.oversize(this.nodes.length + 1, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.nodes, 0, newNodes, 0, this.nodes.length);
            int end = newNodes.length;
            for (int i = depth; i < end; ++i) {
                newNodes[i] = new PathNode();
            }
            this.nodes = newNodes;
        }
    }

    private static class PathNode {
        public int state;
        public int to;
        public int transition;
        public int label;
        private final Transition t = new Transition();

        private PathNode() {
        }

        public void resetState(Automaton a, int state) {
            assert (a.getNumTransitions(state) != 0);
            this.state = state;
            this.transition = 0;
            a.getTransition(state, 0, this.t);
            this.label = this.t.min;
            this.to = this.t.dest;
        }

        public int nextLabel(Automaton a) {
            if (this.label > this.t.max) {
                ++this.transition;
                if (this.transition >= a.getNumTransitions(this.state)) {
                    this.label = -1;
                    return -1;
                }
                a.getTransition(this.state, this.transition, this.t);
                this.label = this.t.min;
                this.to = this.t.dest;
            }
            return this.label++;
        }
    }
}

