/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;

public class QueryBuilder {
    private Analyzer analyzer;
    private boolean enablePositionIncrements = true;

    public QueryBuilder(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public Query createBooleanQuery(String field2, String queryText) {
        return this.createBooleanQuery(field2, queryText, BooleanClause.Occur.SHOULD);
    }

    public Query createBooleanQuery(String field2, String queryText, BooleanClause.Occur operator) {
        if (operator != BooleanClause.Occur.SHOULD && operator != BooleanClause.Occur.MUST) {
            throw new IllegalArgumentException("invalid operator: only SHOULD or MUST are allowed");
        }
        return this.createFieldQuery(this.analyzer, operator, field2, queryText, false, 0);
    }

    public Query createPhraseQuery(String field2, String queryText) {
        return this.createPhraseQuery(field2, queryText, 0);
    }

    public Query createPhraseQuery(String field2, String queryText, int phraseSlop) {
        return this.createFieldQuery(this.analyzer, BooleanClause.Occur.MUST, field2, queryText, true, phraseSlop);
    }

    public Query createMinShouldMatchQuery(String field2, String queryText, float fraction) {
        if (Float.isNaN(fraction) || fraction < 0.0f || fraction > 1.0f) {
            throw new IllegalArgumentException("fraction should be >= 0 and <= 1");
        }
        if (fraction == 1.0f) {
            return this.createBooleanQuery(field2, queryText, BooleanClause.Occur.MUST);
        }
        Query query = this.createFieldQuery(this.analyzer, BooleanClause.Occur.SHOULD, field2, queryText, false, 0);
        if (query instanceof BooleanQuery) {
            BooleanQuery bq = (BooleanQuery)query;
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.setDisableCoord(bq.isCoordDisabled());
            builder.setMinimumNumberShouldMatch((int)(fraction * (float)bq.clauses().size()));
            for (BooleanClause clause : bq) {
                builder.add(clause);
            }
            query = builder.build();
        }
        return query;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public boolean getEnablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    public void setEnablePositionIncrements(boolean enable) {
        this.enablePositionIncrements = enable;
    }

    /*
     * Exception decompiling
     */
    protected final Query createFieldQuery(Analyzer analyzer, BooleanClause.Occur operator, String field, String queryText, boolean quoted, int phraseSlop) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 13 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Query analyzeTerm(String field2, TokenStream stream) throws IOException {
        TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
        stream.reset();
        if (!stream.incrementToken()) {
            throw new AssertionError();
        }
        return this.newTermQuery(new Term(field2, termAtt.getBytesRef()));
    }

    private Query analyzeBoolean(String field2, TokenStream stream) throws IOException {
        BooleanQuery.Builder q = new BooleanQuery.Builder();
        q.setDisableCoord(true);
        TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
        stream.reset();
        while (stream.incrementToken()) {
            Query currentQuery = this.newTermQuery(new Term(field2, termAtt.getBytesRef()));
            q.add(currentQuery, BooleanClause.Occur.SHOULD);
        }
        return q.build();
    }

    private void add(BooleanQuery.Builder q, BooleanQuery current, BooleanClause.Occur operator) {
        if (current.clauses().isEmpty()) {
            return;
        }
        if (current.clauses().size() == 1) {
            q.add(current.clauses().iterator().next().getQuery(), operator);
        } else {
            q.add(current, operator);
        }
    }

    private Query analyzeMultiBoolean(String field2, TokenStream stream, BooleanClause.Occur operator) throws IOException {
        BooleanQuery.Builder q = this.newBooleanQuery(false);
        BooleanQuery.Builder currentQuery = this.newBooleanQuery(true);
        TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
        PositionIncrementAttribute posIncrAtt = stream.getAttribute(PositionIncrementAttribute.class);
        stream.reset();
        while (stream.incrementToken()) {
            BytesRef bytes2 = termAtt.getBytesRef();
            if (posIncrAtt.getPositionIncrement() != 0) {
                this.add(q, currentQuery.build(), operator);
                currentQuery = this.newBooleanQuery(true);
            }
            currentQuery.add(this.newTermQuery(new Term(field2, termAtt.getBytesRef())), BooleanClause.Occur.SHOULD);
        }
        this.add(q, currentQuery.build(), operator);
        return q.build();
    }

    private Query analyzePhrase(String field2, TokenStream stream, int slop) throws IOException {
        PhraseQuery.Builder builder = new PhraseQuery.Builder();
        builder.setSlop(slop);
        TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
        PositionIncrementAttribute posIncrAtt = stream.getAttribute(PositionIncrementAttribute.class);
        int position2 = -1;
        stream.reset();
        while (stream.incrementToken()) {
            BytesRef bytes2 = termAtt.getBytesRef();
            position2 = this.enablePositionIncrements ? (position2 += posIncrAtt.getPositionIncrement()) : ++position2;
            builder.add(new Term(field2, bytes2), position2);
        }
        return builder.build();
    }

    private Query analyzeMultiPhrase(String field2, TokenStream stream, int slop) throws IOException {
        MultiPhraseQuery mpq = this.newMultiPhraseQuery();
        mpq.setSlop(slop);
        TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
        PositionIncrementAttribute posIncrAtt = stream.getAttribute(PositionIncrementAttribute.class);
        int position2 = -1;
        ArrayList<Term> multiTerms = new ArrayList<Term>();
        stream.reset();
        while (stream.incrementToken()) {
            int positionIncrement = posIncrAtt.getPositionIncrement();
            if (positionIncrement > 0 && multiTerms.size() > 0) {
                if (this.enablePositionIncrements) {
                    mpq.add(multiTerms.toArray(new Term[0]), position2);
                } else {
                    mpq.add(multiTerms.toArray(new Term[0]));
                }
                multiTerms.clear();
            }
            position2 += positionIncrement;
            multiTerms.add(new Term(field2, termAtt.getBytesRef()));
        }
        if (this.enablePositionIncrements) {
            mpq.add(multiTerms.toArray(new Term[0]), position2);
        } else {
            mpq.add(multiTerms.toArray(new Term[0]));
        }
        return mpq;
    }

    protected BooleanQuery.Builder newBooleanQuery(boolean disableCoord) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.setDisableCoord(disableCoord);
        return builder;
    }

    protected Query newTermQuery(Term term) {
        return new TermQuery(term);
    }

    protected MultiPhraseQuery newMultiPhraseQuery() {
        return new MultiPhraseQuery();
    }
}

