/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;

public final class IntsRef
implements Comparable<IntsRef>,
Cloneable {
    public static final int[] EMPTY_INTS = new int[0];
    public int[] ints;
    public int offset;
    public int length;

    public IntsRef() {
        this.ints = EMPTY_INTS;
    }

    public IntsRef(int capacity) {
        this.ints = new int[capacity];
    }

    public IntsRef(int[] ints, int offset, int length2) {
        this.ints = ints;
        this.offset = offset;
        this.length = length2;
        assert (this.isValid());
    }

    public IntsRef clone() {
        return new IntsRef(this.ints, this.offset, this.length);
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 0;
        int end = this.offset + this.length;
        for (int i = this.offset; i < end; ++i) {
            result2 = 31 * result2 + this.ints[i];
        }
        return result2;
    }

    public boolean equals(Object other2) {
        if (other2 == null) {
            return false;
        }
        if (other2 instanceof IntsRef) {
            return this.intsEquals((IntsRef)other2);
        }
        return false;
    }

    public boolean intsEquals(IntsRef other2) {
        if (this.length == other2.length) {
            int otherUpto = other2.offset;
            int[] otherInts = other2.ints;
            int end = this.offset + this.length;
            int upto = this.offset;
            while (upto < end) {
                if (this.ints[upto] != otherInts[otherUpto]) {
                    return false;
                }
                ++upto;
                ++otherUpto;
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(IntsRef other2) {
        if (this == other2) {
            return 0;
        }
        int[] aInts = this.ints;
        int aUpto = this.offset;
        int[] bInts = other2.ints;
        int bUpto = other2.offset;
        int aStop = aUpto + Math.min(this.length, other2.length);
        while (aUpto < aStop) {
            int bInt;
            int aInt;
            if ((aInt = aInts[aUpto++]) > (bInt = bInts[bUpto++])) {
                return 1;
            }
            if (aInt >= bInt) continue;
            return -1;
        }
        return this.length - other2.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int end = this.offset + this.length;
        for (int i = this.offset; i < end; ++i) {
            if (i > this.offset) {
                sb.append(' ');
            }
            sb.append(Integer.toHexString(this.ints[i]));
        }
        sb.append(']');
        return sb.toString();
    }

    public static IntsRef deepCopyOf(IntsRef other2) {
        return new IntsRef(Arrays.copyOfRange(other2.ints, other2.offset, other2.offset + other2.length), 0, other2.length);
    }

    public boolean isValid() {
        if (this.ints == null) {
            throw new IllegalStateException("ints is null");
        }
        if (this.length < 0) {
            throw new IllegalStateException("length is negative: " + this.length);
        }
        if (this.length > this.ints.length) {
            throw new IllegalStateException("length is out of bounds: " + this.length + ",ints.length=" + this.ints.length);
        }
        if (this.offset < 0) {
            throw new IllegalStateException("offset is negative: " + this.offset);
        }
        if (this.offset > this.ints.length) {
            throw new IllegalStateException("offset out of bounds: " + this.offset + ",ints.length=" + this.ints.length);
        }
        if (this.offset + this.length < 0) {
            throw new IllegalStateException("offset+length is negative: offset=" + this.offset + ",length=" + this.length);
        }
        if (this.offset + this.length > this.ints.length) {
            throw new IllegalStateException("offset+length out of bounds: offset=" + this.offset + ",length=" + this.length + ",ints.length=" + this.ints.length);
        }
        return true;
    }
}

