/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.util.Sorter;

public abstract class IntroSorter
extends Sorter {
    static int ceilLog2(int n) {
        return 32 - Integer.numberOfLeadingZeros(n - 1);
    }

    @Override
    public final void sort(int from2, int to2) {
        this.checkRange(from2, to2);
        this.quicksort(from2, to2, IntroSorter.ceilLog2(to2 - from2));
    }

    void quicksort(int from2, int to2, int maxDepth2) {
        if (to2 - from2 < 20) {
            this.insertionSort(from2, to2);
            return;
        }
        if (--maxDepth2 < 0) {
            this.heapSort(from2, to2);
            return;
        }
        int mid = from2 + to2 >>> 1;
        if (this.compare(from2, mid) > 0) {
            this.swap(from2, mid);
        }
        if (this.compare(mid, to2 - 1) > 0) {
            this.swap(mid, to2 - 1);
            if (this.compare(from2, mid) > 0) {
                this.swap(from2, mid);
            }
        }
        int left2 = from2 + 1;
        int right2 = to2 - 2;
        this.setPivot(mid);
        while (true) {
            if (this.comparePivot(right2) < 0) {
                --right2;
                continue;
            }
            while (left2 < right2 && this.comparePivot(left2) >= 0) {
                ++left2;
            }
            if (left2 >= right2) break;
            this.swap(left2, right2);
            --right2;
        }
        this.quicksort(from2, left2 + 1, maxDepth2);
        this.quicksort(left2 + 1, to2, maxDepth2);
    }

    protected abstract void setPivot(int var1);

    protected abstract int comparePivot(int var1);
}

