/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.SparseFixedBitSet;

public class BitSetIterator
extends DocIdSetIterator {
    private final BitSet bits;
    private final int length;
    private final long cost;
    private int doc = -1;

    private static <T extends BitSet> T getBitSet(DocIdSetIterator iterator2, Class<? extends T> clazz) {
        if (iterator2 instanceof BitSetIterator) {
            BitSet bits2 = ((BitSetIterator)iterator2).bits;
            assert (bits2 != null);
            if (clazz.isInstance(bits2)) {
                return (T)((BitSet)clazz.cast(bits2));
            }
        }
        return null;
    }

    public static FixedBitSet getFixedBitSetOrNull(DocIdSetIterator iterator2) {
        return BitSetIterator.getBitSet(iterator2, FixedBitSet.class);
    }

    public static SparseFixedBitSet getSparseFixedBitSetOrNull(DocIdSetIterator iterator2) {
        return BitSetIterator.getBitSet(iterator2, SparseFixedBitSet.class);
    }

    public BitSetIterator(BitSet bits2, long cost) {
        this.bits = bits2;
        this.length = bits2.length();
        this.cost = cost;
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public int nextDoc() {
        return this.advance(this.doc + 1);
    }

    @Override
    public int advance(int target) {
        if (target >= this.length) {
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        this.doc = this.bits.nextSetBit(target);
        return this.doc;
    }

    @Override
    public long cost() {
        return this.cost;
    }
}

