/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeReflector;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.SuppressForbidden;

public abstract class AttributeImpl
implements Cloneable,
Attribute {
    public abstract void clear();

    public final String reflectAsString(final boolean prependAttClass) {
        final StringBuilder buffer = new StringBuilder();
        this.reflectWith(new AttributeReflector(){

            @Override
            public void reflect(Class<? extends Attribute> attClass, String key, Object value) {
                if (buffer.length() > 0) {
                    buffer.append(',');
                }
                if (prependAttClass) {
                    buffer.append(attClass.getName()).append('#');
                }
                buffer.append(key).append('=').append(value == null ? "null" : value);
            }
        });
        return buffer.toString();
    }

    public void reflectWith(AttributeReflector reflector) {
        Field[] fields;
        Class<?> clazz = this.getClass();
        Class<? extends Attribute>[] interfaces = AttributeSource.getAttributeInterfaces(clazz);
        if (interfaces.length != 1) {
            throw new UnsupportedOperationException(clazz.getName() + " implements more than one Attribute interface, the default reflectWith() implementation cannot handle this.");
        }
        Class<? extends Attribute> interf = interfaces[0];
        for (final Field f : fields = clazz.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            reflector.reflect(interf, f.getName(), AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                @SuppressForbidden(reason="This methods needs to access private attribute fields. Method will be abstract in 6.x")
                public Object run() {
                    try {
                        f.setAccessible(true);
                        return f.get(AttributeImpl.this);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("Cannot access private fields.", e);
                    }
                }
            }));
        }
    }

    public abstract void copyTo(AttributeImpl var1);

    public AttributeImpl clone() {
        AttributeImpl clone2 = null;
        try {
            clone2 = (AttributeImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return clone2;
    }
}

