/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Accountable;

public class RAMFile
implements Accountable {
    protected final ArrayList<byte[]> buffers = new ArrayList();
    long length;
    RAMDirectory directory;
    protected long sizeInBytes;

    public RAMFile() {
    }

    RAMFile(RAMDirectory directory) {
        this.directory = directory;
    }

    public synchronized long getLength() {
        return this.length;
    }

    protected synchronized void setLength(long length2) {
        this.length = length2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final byte[] addBuffer(int size2) {
        byte[] buffer = this.newBuffer(size2);
        RAMFile rAMFile = this;
        synchronized (rAMFile) {
            this.buffers.add(buffer);
            this.sizeInBytes += (long)size2;
        }
        if (this.directory != null) {
            this.directory.sizeInBytes.getAndAdd(size2);
        }
        return buffer;
    }

    protected final synchronized byte[] getBuffer(int index) {
        return this.buffers.get(index);
    }

    protected final synchronized int numBuffers() {
        return this.buffers.size();
    }

    protected byte[] newBuffer(int size2) {
        return new byte[size2];
    }

    @Override
    public synchronized long ramBytesUsed() {
        return this.sizeInBytes;
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(length=" + this.length + ")";
    }

    public int hashCode() {
        int h = (int)(this.length ^ this.length >>> 32);
        for (byte[] block : this.buffers) {
            h = 31 * h + Arrays.hashCode(block);
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RAMFile other2 = (RAMFile)obj;
        if (this.length != other2.length) {
            return false;
        }
        if (this.buffers.size() != other2.buffers.size()) {
            return false;
        }
        for (int i = 0; i < this.buffers.size(); ++i) {
            if (Arrays.equals(this.buffers.get(i), other2.buffers.get(i))) continue;
            return false;
        }
        return true;
    }
}

