/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.Objects;
import org.apache.lucene.store.ByteBufferIndexInput;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.SuppressForbidden;

public class MMapDirectory
extends FSDirectory {
    private boolean useUnmapHack = UNMAP_SUPPORTED;
    private boolean preload;
    public static final int DEFAULT_MAX_CHUNK_SIZE = Constants.JRE_IS_64BIT ? 0x40000000 : 0x10000000;
    final int chunkSizePower;
    public static final boolean UNMAP_SUPPORTED = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        @SuppressForbidden(reason="Needs access to private APIs in DirectBuffer and sun.misc.Cleaner to enable hack")
        public Boolean run() {
            try {
                Class<?> dbClazz = Class.forName("java.nio.DirectByteBuffer");
                Method cleanerMethod = dbClazz.getMethod("cleaner", new Class[0]);
                cleanerMethod.setAccessible(true);
                Class<?> cleanerClazz = Class.forName("sun.misc.Cleaner");
                cleanerClazz.getMethod("clean", new Class[0]);
                return Objects.equals(cleanerMethod.getReturnType(), cleanerClazz);
            }
            catch (Exception e) {
                return false;
            }
        }
    });
    private static final ByteBufferIndexInput.BufferCleaner CLEANER = new ByteBufferIndexInput.BufferCleaner(){

        @Override
        public void freeBuffer(ByteBufferIndexInput parent2, final ByteBuffer buffer) throws IOException {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    @SuppressForbidden(reason="Needs access to private APIs in DirectBuffer and sun.misc.Cleaner to enable hack")
                    public Void run() throws Exception {
                        Method getCleanerMethod = buffer.getClass().getMethod("cleaner", new Class[0]);
                        getCleanerMethod.setAccessible(true);
                        Object cleaner = getCleanerMethod.invoke((Object)buffer, new Object[0]);
                        if (cleaner != null) {
                            cleaner.getClass().getMethod("clean", new Class[0]).invoke(cleaner, new Object[0]);
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new IOException("Unable to unmap the mapped buffer: " + parent2.toString(), e.getCause());
            }
        }
    };

    public MMapDirectory(Path path, LockFactory lockFactory) throws IOException {
        this(path, lockFactory, DEFAULT_MAX_CHUNK_SIZE);
    }

    public MMapDirectory(Path path) throws IOException {
        this(path, FSLockFactory.getDefault());
    }

    public MMapDirectory(Path path, int maxChunkSize) throws IOException {
        this(path, FSLockFactory.getDefault(), maxChunkSize);
    }

    public MMapDirectory(Path path, LockFactory lockFactory, int maxChunkSize) throws IOException {
        super(path, lockFactory);
        if (maxChunkSize <= 0) {
            throw new IllegalArgumentException("Maximum chunk size for mmap must be >0");
        }
        this.chunkSizePower = 31 - Integer.numberOfLeadingZeros(maxChunkSize);
        assert (this.chunkSizePower >= 0 && this.chunkSizePower <= 30);
    }

    public void setUseUnmap(boolean useUnmapHack) {
        if (useUnmapHack && !UNMAP_SUPPORTED) {
            throw new IllegalArgumentException("Unmap hack not supported on this platform!");
        }
        this.useUnmapHack = useUnmapHack;
    }

    public boolean getUseUnmap() {
        return this.useUnmapHack;
    }

    public void setPreload(boolean preload) {
        this.preload = preload;
    }

    public boolean getPreload() {
        return this.preload;
    }

    public final int getMaxChunkSize() {
        return 1 << this.chunkSizePower;
    }

    @Override
    public IndexInput openInput(String name2, IOContext context) throws IOException {
        this.ensureOpen();
        Path path = this.directory.resolve(name2);
        try (FileChannel c = FileChannel.open(path, StandardOpenOption.READ);){
            String resourceDescription = "MMapIndexInput(path=\"" + path.toString() + "\")";
            boolean useUnmap = this.getUseUnmap();
            ByteBufferIndexInput byteBufferIndexInput = ByteBufferIndexInput.newInstance(resourceDescription, this.map(resourceDescription, c, 0L, c.size()), c.size(), this.chunkSizePower, useUnmap ? CLEANER : null, useUnmap);
            return byteBufferIndexInput;
        }
    }

    final ByteBuffer[] map(String resourceDescription, FileChannel fc, long offset, long length2) throws IOException {
        if (length2 >>> this.chunkSizePower >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("RandomAccessFile too big for chunk size: " + resourceDescription);
        }
        long chunkSize = 1L << this.chunkSizePower;
        int nrBuffers = (int)(length2 >>> this.chunkSizePower) + 1;
        ByteBuffer[] buffers = new ByteBuffer[nrBuffers];
        long bufferStart = 0L;
        for (int bufNr = 0; bufNr < nrBuffers; ++bufNr) {
            MappedByteBuffer buffer;
            int bufSize = (int)(length2 > bufferStart + chunkSize ? chunkSize : length2 - bufferStart);
            try {
                buffer = fc.map(FileChannel.MapMode.READ_ONLY, offset + bufferStart, bufSize);
            }
            catch (IOException ioe) {
                throw this.convertMapFailedIOException(ioe, resourceDescription, bufSize);
            }
            if (this.preload) {
                buffer.load();
            }
            buffers[bufNr] = buffer;
            bufferStart += (long)bufSize;
        }
        return buffers;
    }

    private IOException convertMapFailedIOException(IOException ioe, String resourceDescription, int bufSize) {
        Throwable originalCause;
        String originalMessage;
        if (ioe.getCause() instanceof OutOfMemoryError) {
            originalMessage = "Map failed";
            originalCause = null;
        } else {
            originalMessage = ioe.getMessage();
            originalCause = ioe.getCause();
        }
        String moreInfo = !Constants.JRE_IS_64BIT ? "MMapDirectory should only be used on 64bit platforms, because the address space on 32bit operating systems is too small. " : (Constants.WINDOWS ? "Windows is unfortunately very limited on virtual address space. If your index size is several hundred Gigabytes, consider changing to Linux. " : (Constants.LINUX ? "Please review 'ulimit -v', 'ulimit -m' (both should return 'unlimited'), and 'sysctl vm.max_map_count'. " : "Please review 'ulimit -v', 'ulimit -m' (both should return 'unlimited'). "));
        IOException newIoe = new IOException(String.format(Locale.ENGLISH, "%s: %s [this may be caused by lack of enough unfragmented virtual address space or too restrictive virtual memory limits enforced by the operating system, preventing us to map a chunk of %d bytes. %sMore information: http://blog.thetaphi.de/2012/07/use-lucenes-mmapdirectory-on-64bit.html]", originalMessage, resourceDescription, bufSize, moreInfo), originalCause);
        newIoe.setStackTrace(ioe.getStackTrace());
        return newIoe;
    }
}

