/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;

public final class LockValidatingDirectoryWrapper
extends FilterDirectory {
    private final Lock writeLock;

    public LockValidatingDirectoryWrapper(Directory in2, Lock writeLock) {
        super(in2);
        this.writeLock = writeLock;
    }

    @Override
    public void deleteFile(String name2) throws IOException {
        this.writeLock.ensureValid();
        this.in.deleteFile(name2);
    }

    @Override
    public IndexOutput createOutput(String name2, IOContext context) throws IOException {
        this.writeLock.ensureValid();
        return this.in.createOutput(name2, context);
    }

    @Override
    public void copyFrom(Directory from2, String src, String dest, IOContext context) throws IOException {
        this.writeLock.ensureValid();
        this.in.copyFrom(from2, src, dest, context);
    }

    @Override
    public void renameFile(String source, String dest) throws IOException {
        this.writeLock.ensureValid();
        this.in.renameFile(source, dest);
    }

    @Override
    public void sync(Collection<String> names) throws IOException {
        this.writeLock.ensureValid();
        this.in.sync(names);
    }
}

