/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.util.IOUtils;

public class FileSwitchDirectory
extends Directory {
    private final Directory secondaryDir;
    private final Directory primaryDir;
    private final Set<String> primaryExtensions;
    private boolean doClose;

    public FileSwitchDirectory(Set<String> primaryExtensions, Directory primaryDir, Directory secondaryDir, boolean doClose) {
        this.primaryExtensions = primaryExtensions;
        this.primaryDir = primaryDir;
        this.secondaryDir = secondaryDir;
        this.doClose = doClose;
    }

    public Directory getPrimaryDir() {
        return this.primaryDir;
    }

    public Directory getSecondaryDir() {
        return this.secondaryDir;
    }

    @Override
    public Lock obtainLock(String name2) throws IOException {
        return this.getDirectory(name2).obtainLock(name2);
    }

    @Override
    public void close() throws IOException {
        if (this.doClose) {
            IOUtils.close(this.primaryDir, this.secondaryDir);
            this.doClose = false;
        }
    }

    @Override
    public String[] listAll() throws IOException {
        NoSuchFileException exc;
        HashSet<String> files2;
        block8: {
            files2 = new HashSet<String>();
            exc = null;
            try {
                for (String f : this.primaryDir.listAll()) {
                    files2.add(f);
                }
            }
            catch (NoSuchFileException e) {
                exc = e;
            }
            try {
                for (String f : this.secondaryDir.listAll()) {
                    files2.add(f);
                }
            }
            catch (NoSuchFileException e) {
                if (exc != null) {
                    throw exc;
                }
                if (!files2.isEmpty()) break block8;
                throw e;
            }
        }
        if (exc != null && files2.isEmpty()) {
            throw exc;
        }
        return files2.toArray(new String[files2.size()]);
    }

    public static String getExtension(String name2) {
        int i = name2.lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        return name2.substring(i + 1, name2.length());
    }

    private Directory getDirectory(String name2) {
        String ext = FileSwitchDirectory.getExtension(name2);
        if (this.primaryExtensions.contains(ext)) {
            return this.primaryDir;
        }
        return this.secondaryDir;
    }

    @Override
    public void deleteFile(String name2) throws IOException {
        this.getDirectory(name2).deleteFile(name2);
    }

    @Override
    public long fileLength(String name2) throws IOException {
        return this.getDirectory(name2).fileLength(name2);
    }

    @Override
    public IndexOutput createOutput(String name2, IOContext context) throws IOException {
        return this.getDirectory(name2).createOutput(name2, context);
    }

    @Override
    public void sync(Collection<String> names) throws IOException {
        ArrayList<String> primaryNames = new ArrayList<String>();
        ArrayList<String> secondaryNames = new ArrayList<String>();
        for (String name2 : names) {
            if (this.primaryExtensions.contains(FileSwitchDirectory.getExtension(name2))) {
                primaryNames.add(name2);
                continue;
            }
            secondaryNames.add(name2);
        }
        this.primaryDir.sync(primaryNames);
        this.secondaryDir.sync(secondaryNames);
    }

    @Override
    public void renameFile(String source, String dest) throws IOException {
        Directory sourceDir = this.getDirectory(source);
        if (sourceDir != this.getDirectory(dest)) {
            throw new AtomicMoveNotSupportedException(source, dest, "source and dest are in different directories");
        }
        sourceDir.renameFile(source, dest);
    }

    @Override
    public IndexInput openInput(String name2, IOContext context) throws IOException {
        return this.getDirectory(name2).openInput(name2, context);
    }
}

