/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.BytesRef;

public class ByteArrayDataOutput
extends DataOutput {
    private byte[] bytes;
    private int pos;
    private int limit;

    public ByteArrayDataOutput(byte[] bytes2) {
        this.reset(bytes2);
    }

    public ByteArrayDataOutput(byte[] bytes2, int offset, int len) {
        this.reset(bytes2, offset, len);
    }

    public ByteArrayDataOutput() {
        this.reset(BytesRef.EMPTY_BYTES);
    }

    public void reset(byte[] bytes2) {
        this.reset(bytes2, 0, bytes2.length);
    }

    public void reset(byte[] bytes2, int offset, int len) {
        this.bytes = bytes2;
        this.pos = offset;
        this.limit = offset + len;
    }

    public int getPosition() {
        return this.pos;
    }

    @Override
    public void writeByte(byte b) {
        assert (this.pos < this.limit);
        this.bytes[this.pos++] = b;
    }

    @Override
    public void writeBytes(byte[] b, int offset, int length2) {
        assert (this.pos + length2 <= this.limit);
        System.arraycopy(b, offset, this.bytes, this.pos, length2);
        this.pos += length2;
    }
}

