/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.Spans;

abstract class SpanContainQuery
extends SpanQuery
implements Cloneable {
    SpanQuery big;
    SpanQuery little;

    SpanContainQuery(SpanQuery big, SpanQuery little) {
        this.big = Objects.requireNonNull(big);
        this.little = Objects.requireNonNull(little);
        Objects.requireNonNull(big.getField());
        Objects.requireNonNull(little.getField());
        if (!big.getField().equals(little.getField())) {
            throw new IllegalArgumentException("big and little not same field");
        }
    }

    @Override
    public String getField() {
        return this.big.getField();
    }

    String toString(String field2, String name2) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(name2);
        buffer.append("(");
        buffer.append(this.big.toString(field2));
        buffer.append(", ");
        buffer.append(this.little.toString(field2));
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.getBoost() != 1.0f) {
            return super.rewrite(reader);
        }
        SpanQuery rewrittenBig = (SpanQuery)this.big.rewrite(reader);
        SpanQuery rewrittenLittle = (SpanQuery)this.little.rewrite(reader);
        if (this.big != rewrittenBig || this.little != rewrittenLittle) {
            SpanContainQuery clone2 = (SpanContainQuery)super.clone();
            clone2.big = rewrittenBig;
            clone2.little = rewrittenLittle;
            return clone2;
        }
        return super.rewrite(reader);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        SpanContainQuery other2 = (SpanContainQuery)o;
        return this.big.equals(other2.big) && this.little.equals(other2.little);
    }

    @Override
    public int hashCode() {
        int h = Integer.rotateLeft(super.hashCode(), 1);
        h ^= this.big.hashCode();
        h = Integer.rotateLeft(h, 1);
        return h ^= this.little.hashCode();
    }

    public abstract class SpanContainWeight
    extends SpanWeight {
        final SpanWeight bigWeight;
        final SpanWeight littleWeight;

        public SpanContainWeight(IndexSearcher searcher, Map<Term, TermContext> terms, SpanWeight bigWeight, SpanWeight littleWeight) throws IOException {
            super(SpanContainQuery.this, searcher, terms);
            this.bigWeight = bigWeight;
            this.littleWeight = littleWeight;
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            this.bigWeight.extractTerms(terms);
            this.littleWeight.extractTerms(terms);
        }

        ArrayList<Spans> prepareConjunction(LeafReaderContext context, SpanWeight.Postings postings) throws IOException {
            Spans bigSpans = this.bigWeight.getSpans(context, postings);
            if (bigSpans == null) {
                return null;
            }
            Spans littleSpans = this.littleWeight.getSpans(context, postings);
            if (littleSpans == null) {
                return null;
            }
            ArrayList<Spans> bigAndLittle = new ArrayList<Spans>();
            bigAndLittle.add(bigSpans);
            bigAndLittle.add(littleSpans);
            return bigAndLittle;
        }

        @Override
        public void extractTermContexts(Map<Term, TermContext> contexts) {
            this.bigWeight.extractTermContexts(contexts);
            this.littleWeight.extractTermContexts(contexts);
        }
    }
}

