/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.similarities;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.BytesRef;

public abstract class TFIDFSimilarity
extends Similarity {
    @Override
    public abstract float coord(int var1, int var2);

    @Override
    public abstract float queryNorm(float var1);

    public abstract float tf(float var1);

    public Explanation idfExplain(CollectionStatistics collectionStats, TermStatistics termStats) {
        long df = termStats.docFreq();
        long max2 = collectionStats.maxDoc();
        float idf = this.idf(df, max2);
        return Explanation.match(idf, "idf(docFreq=" + df + ", maxDocs=" + max2 + ")", new Explanation[0]);
    }

    public Explanation idfExplain(CollectionStatistics collectionStats, TermStatistics[] termStats) {
        long max2 = collectionStats.maxDoc();
        float idf = 0.0f;
        ArrayList<Explanation> subs = new ArrayList<Explanation>();
        for (TermStatistics stat : termStats) {
            long df = stat.docFreq();
            float termIdf = this.idf(df, max2);
            subs.add(Explanation.match(termIdf, "idf(docFreq=" + df + ", maxDocs=" + max2 + ")", new Explanation[0]));
            idf += termIdf;
        }
        return Explanation.match(idf, "idf(), sum of:", subs);
    }

    public abstract float idf(long var1, long var3);

    public abstract float lengthNorm(FieldInvertState var1);

    @Override
    public final long computeNorm(FieldInvertState state) {
        float normValue = this.lengthNorm(state);
        return this.encodeNormValue(normValue);
    }

    public abstract float decodeNormValue(long var1);

    public abstract long encodeNormValue(float var1);

    public abstract float sloppyFreq(int var1);

    public abstract float scorePayload(int var1, int var2, int var3, BytesRef var4);

    @Override
    public final Similarity.SimWeight computeWeight(CollectionStatistics collectionStats, TermStatistics ... termStats) {
        Explanation idf = termStats.length == 1 ? this.idfExplain(collectionStats, termStats[0]) : this.idfExplain(collectionStats, termStats);
        return new IDFStats(collectionStats.field(), idf);
    }

    @Override
    public final Similarity.SimScorer simScorer(Similarity.SimWeight stats, LeafReaderContext context) throws IOException {
        IDFStats idfstats = (IDFStats)stats;
        return new TFIDFSimScorer(idfstats, context.reader().getNormValues(idfstats.field));
    }

    private Explanation explainQuery(IDFStats stats) {
        ArrayList<Explanation> subs = new ArrayList<Explanation>();
        Explanation boostExpl = Explanation.match(stats.boost, "boost", new Explanation[0]);
        if (stats.boost != 1.0f) {
            subs.add(boostExpl);
        }
        subs.add(stats.idf);
        Explanation queryNormExpl = Explanation.match(stats.queryNorm, "queryNorm", new Explanation[0]);
        subs.add(queryNormExpl);
        return Explanation.match(boostExpl.getValue() * stats.idf.getValue() * queryNormExpl.getValue(), "queryWeight, product of:", subs);
    }

    private Explanation explainField(int doc2, Explanation freq2, IDFStats stats, NumericDocValues norms) {
        Explanation tfExplanation = Explanation.match(this.tf(freq2.getValue()), "tf(freq=" + freq2.getValue() + "), with freq of:", freq2);
        Explanation fieldNormExpl = Explanation.match(norms != null ? this.decodeNormValue(norms.get(doc2)) : 1.0f, "fieldNorm(doc=" + doc2 + ")", new Explanation[0]);
        return Explanation.match(tfExplanation.getValue() * stats.idf.getValue() * fieldNormExpl.getValue(), "fieldWeight in " + doc2 + ", product of:", tfExplanation, stats.idf, fieldNormExpl);
    }

    private Explanation explainScore(int doc2, Explanation freq2, IDFStats stats, NumericDocValues norms) {
        Explanation queryExpl = this.explainQuery(stats);
        Explanation fieldExpl = this.explainField(doc2, freq2, stats, norms);
        if (queryExpl.getValue() == 1.0f) {
            return fieldExpl;
        }
        return Explanation.match(queryExpl.getValue() * fieldExpl.getValue(), "score(doc=" + doc2 + ",freq=" + freq2.getValue() + "), product of:", queryExpl, fieldExpl);
    }

    private static class IDFStats
    extends Similarity.SimWeight {
        private final String field;
        private final Explanation idf;
        private float queryNorm;
        private float boost;
        private float queryWeight;
        private float value;

        public IDFStats(String field2, Explanation idf) {
            this.field = field2;
            this.idf = idf;
            this.normalize(1.0f, 1.0f);
        }

        @Override
        public float getValueForNormalization() {
            return this.queryWeight * this.queryWeight;
        }

        @Override
        public void normalize(float queryNorm, float boost) {
            this.boost = boost;
            this.queryNorm = queryNorm;
            this.queryWeight = queryNorm * boost * this.idf.getValue();
            this.value = this.queryWeight * this.idf.getValue();
        }
    }

    private final class TFIDFSimScorer
    extends Similarity.SimScorer {
        private final IDFStats stats;
        private final float weightValue;
        private final NumericDocValues norms;

        TFIDFSimScorer(IDFStats stats, NumericDocValues norms) throws IOException {
            this.stats = stats;
            this.weightValue = stats.value;
            this.norms = norms;
        }

        @Override
        public float score(int doc2, float freq2) {
            float raw2 = TFIDFSimilarity.this.tf(freq2) * this.weightValue;
            return this.norms == null ? raw2 : raw2 * TFIDFSimilarity.this.decodeNormValue(this.norms.get(doc2));
        }

        @Override
        public float computeSlopFactor(int distance) {
            return TFIDFSimilarity.this.sloppyFreq(distance);
        }

        @Override
        public float computePayloadFactor(int doc2, int start, int end, BytesRef payload) {
            return TFIDFSimilarity.this.scorePayload(doc2, start, end, payload);
        }

        @Override
        public Explanation explain(int doc2, Explanation freq2) {
            return TFIDFSimilarity.this.explainScore(doc2, freq2, this.stats, this.norms);
        }
    }
}

