/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.similarities;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.similarities.BasicStats;
import org.apache.lucene.search.similarities.MultiSimilarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SmallFloat;

public abstract class SimilarityBase
extends Similarity {
    private static final double LOG_2 = Math.log(2.0);
    protected boolean discountOverlaps = true;
    private static final float[] NORM_TABLE = new float[256];

    public void setDiscountOverlaps(boolean v) {
        this.discountOverlaps = v;
    }

    public boolean getDiscountOverlaps() {
        return this.discountOverlaps;
    }

    @Override
    public final Similarity.SimWeight computeWeight(CollectionStatistics collectionStats, TermStatistics ... termStats) {
        Similarity.SimWeight[] stats = new BasicStats[termStats.length];
        for (int i = 0; i < termStats.length; ++i) {
            stats[i] = this.newStats(collectionStats.field());
            this.fillBasicStats((BasicStats)stats[i], collectionStats, termStats[i]);
        }
        return stats.length == 1 ? stats[0] : new MultiSimilarity.MultiStats(stats);
    }

    protected BasicStats newStats(String field2) {
        return new BasicStats(field2);
    }

    protected void fillBasicStats(BasicStats stats, CollectionStatistics collectionStats, TermStatistics termStats) {
        float avgFieldLength;
        long numberOfFieldTokens;
        long sumTotalTermFreq;
        assert (collectionStats.sumTotalTermFreq() == -1L || collectionStats.sumTotalTermFreq() >= termStats.totalTermFreq());
        long numberOfDocuments = collectionStats.maxDoc();
        long docFreq = termStats.docFreq();
        long totalTermFreq = termStats.totalTermFreq();
        if (totalTermFreq == -1L) {
            totalTermFreq = docFreq;
        }
        if ((sumTotalTermFreq = collectionStats.sumTotalTermFreq()) <= 0L) {
            numberOfFieldTokens = docFreq;
            avgFieldLength = 1.0f;
        } else {
            numberOfFieldTokens = sumTotalTermFreq;
            avgFieldLength = (float)numberOfFieldTokens / (float)numberOfDocuments;
        }
        stats.setNumberOfDocuments(numberOfDocuments);
        stats.setNumberOfFieldTokens(numberOfFieldTokens);
        stats.setAvgFieldLength(avgFieldLength);
        stats.setDocFreq(docFreq);
        stats.setTotalTermFreq(totalTermFreq);
    }

    protected abstract float score(BasicStats var1, float var2, float var3);

    protected void explain(List<Explanation> subExpls, BasicStats stats, int doc2, float freq2, float docLen) {
    }

    protected Explanation explain(BasicStats stats, int doc2, Explanation freq2, float docLen) {
        ArrayList<Explanation> subs = new ArrayList<Explanation>();
        this.explain(subs, stats, doc2, freq2.getValue(), docLen);
        return Explanation.match(this.score(stats, freq2.getValue(), docLen), "score(" + this.getClass().getSimpleName() + ", doc=" + doc2 + ", freq=" + freq2.getValue() + "), computed from:", subs);
    }

    @Override
    public Similarity.SimScorer simScorer(Similarity.SimWeight stats, LeafReaderContext context) throws IOException {
        if (stats instanceof MultiSimilarity.MultiStats) {
            Similarity.SimWeight[] subStats = ((MultiSimilarity.MultiStats)stats).subStats;
            Similarity.SimScorer[] subScorers = new Similarity.SimScorer[subStats.length];
            for (int i = 0; i < subScorers.length; ++i) {
                BasicStats basicstats = (BasicStats)subStats[i];
                subScorers[i] = new BasicSimScorer(basicstats, context.reader().getNormValues(basicstats.field));
            }
            return new MultiSimilarity.MultiSimScorer(subScorers);
        }
        BasicStats basicstats = (BasicStats)stats;
        return new BasicSimScorer(basicstats, context.reader().getNormValues(basicstats.field));
    }

    public abstract String toString();

    @Override
    public long computeNorm(FieldInvertState state) {
        float numTerms = this.discountOverlaps ? (float)(state.getLength() - state.getNumOverlap()) : (float)state.getLength();
        return this.encodeNormValue(state.getBoost(), numTerms);
    }

    protected float decodeNormValue(byte norm) {
        return NORM_TABLE[norm & 0xFF];
    }

    protected byte encodeNormValue(float boost, float length2) {
        return SmallFloat.floatToByte315(boost / (float)Math.sqrt(length2));
    }

    public static double log2(double x) {
        return Math.log(x) / LOG_2;
    }

    static {
        for (int i = 1; i < 256; ++i) {
            float floatNorm = SmallFloat.byte315ToFloat((byte)i);
            SimilarityBase.NORM_TABLE[i] = 1.0f / (floatNorm * floatNorm);
        }
        SimilarityBase.NORM_TABLE[0] = 1.0f / NORM_TABLE[255];
    }

    private class BasicSimScorer
    extends Similarity.SimScorer {
        private final BasicStats stats;
        private final NumericDocValues norms;

        BasicSimScorer(BasicStats stats, NumericDocValues norms) throws IOException {
            this.stats = stats;
            this.norms = norms;
        }

        @Override
        public float score(int doc2, float freq2) {
            return SimilarityBase.this.score(this.stats, freq2, this.norms == null ? 1.0f : SimilarityBase.this.decodeNormValue((byte)this.norms.get(doc2)));
        }

        @Override
        public Explanation explain(int doc2, Explanation freq2) {
            return SimilarityBase.this.explain(this.stats, doc2, freq2, this.norms == null ? 1.0f : SimilarityBase.this.decodeNormValue((byte)this.norms.get(doc2)));
        }

        @Override
        public float computeSlopFactor(int distance) {
            return 1.0f / (float)(distance + 1);
        }

        @Override
        public float computePayloadFactor(int doc2, int start, int end, BytesRef payload) {
            return 1.0f;
        }
    }
}

