/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.similarities;

import java.util.List;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.similarities.AfterEffect;
import org.apache.lucene.search.similarities.BasicModel;
import org.apache.lucene.search.similarities.BasicStats;
import org.apache.lucene.search.similarities.Normalization;
import org.apache.lucene.search.similarities.SimilarityBase;

public class DFRSimilarity
extends SimilarityBase {
    protected final BasicModel basicModel;
    protected final AfterEffect afterEffect;
    protected final Normalization normalization;

    public DFRSimilarity(BasicModel basicModel, AfterEffect afterEffect, Normalization normalization) {
        if (basicModel == null || afterEffect == null || normalization == null) {
            throw new NullPointerException("null parameters not allowed.");
        }
        this.basicModel = basicModel;
        this.afterEffect = afterEffect;
        this.normalization = normalization;
    }

    @Override
    protected float score(BasicStats stats, float freq2, float docLen) {
        float tfn = this.normalization.tfn(stats, freq2, docLen);
        return stats.getBoost() * this.basicModel.score(stats, tfn) * this.afterEffect.score(stats, tfn);
    }

    @Override
    protected void explain(List<Explanation> subs, BasicStats stats, int doc2, float freq2, float docLen) {
        if (stats.getBoost() != 1.0f) {
            subs.add(Explanation.match(stats.getBoost(), "boost", new Explanation[0]));
        }
        Explanation normExpl = this.normalization.explain(stats, freq2, docLen);
        float tfn = normExpl.getValue();
        subs.add(normExpl);
        subs.add(this.basicModel.explain(stats, tfn));
        subs.add(this.afterEffect.explain(stats, tfn));
    }

    @Override
    public String toString() {
        return "DFR " + this.basicModel.toString() + this.afterEffect.toString() + this.normalization.toString();
    }

    public BasicModel getBasicModel() {
        return this.basicModel;
    }

    public AfterEffect getAfterEffect() {
        return this.afterEffect;
    }

    public Normalization getNormalization() {
        return this.normalization;
    }
}

