/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.util.Bits;

public abstract class Weight {
    protected final Query parentQuery;

    protected Weight(Query query) {
        this.parentQuery = query;
    }

    public abstract void extractTerms(Set<Term> var1);

    public abstract Explanation explain(LeafReaderContext var1, int var2) throws IOException;

    public final Query getQuery() {
        return this.parentQuery;
    }

    public abstract float getValueForNormalization() throws IOException;

    public abstract void normalize(float var1, float var2);

    public abstract Scorer scorer(LeafReaderContext var1) throws IOException;

    public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
        Scorer scorer = this.scorer(context);
        if (scorer == null) {
            return null;
        }
        return new DefaultBulkScorer(scorer);
    }

    protected static class DefaultBulkScorer
    extends BulkScorer {
        private final Scorer scorer;
        private final DocIdSetIterator iterator;
        private final TwoPhaseIterator twoPhase;

        public DefaultBulkScorer(Scorer scorer) {
            if (scorer == null) {
                throw new NullPointerException();
            }
            this.scorer = scorer;
            this.iterator = scorer.iterator();
            this.twoPhase = scorer.twoPhaseIterator();
        }

        @Override
        public long cost() {
            return this.iterator.cost();
        }

        @Override
        public int score(LeafCollector collector, Bits acceptDocs, int min2, int max2) throws IOException {
            collector.setScorer(this.scorer);
            if (this.scorer.docID() == -1 && min2 == 0 && max2 == Integer.MAX_VALUE) {
                DefaultBulkScorer.scoreAll(collector, this.iterator, this.twoPhase, acceptDocs);
                return Integer.MAX_VALUE;
            }
            int doc2 = this.scorer.docID();
            if (doc2 < min2) {
                doc2 = this.twoPhase == null ? this.iterator.advance(min2) : this.twoPhase.approximation().advance(min2);
            }
            return DefaultBulkScorer.scoreRange(collector, this.iterator, this.twoPhase, acceptDocs, doc2, max2);
        }

        static int scoreRange(LeafCollector collector, DocIdSetIterator iterator2, TwoPhaseIterator twoPhase, Bits acceptDocs, int currentDoc, int end) throws IOException {
            if (twoPhase == null) {
                while (currentDoc < end) {
                    if (acceptDocs == null || acceptDocs.get(currentDoc)) {
                        collector.collect(currentDoc);
                    }
                    currentDoc = iterator2.nextDoc();
                }
                return currentDoc;
            }
            DocIdSetIterator approximation = twoPhase.approximation();
            while (currentDoc < end) {
                if ((acceptDocs == null || acceptDocs.get(currentDoc)) && twoPhase.matches()) {
                    collector.collect(currentDoc);
                }
                currentDoc = approximation.nextDoc();
            }
            return currentDoc;
        }

        static void scoreAll(LeafCollector collector, DocIdSetIterator iterator2, TwoPhaseIterator twoPhase, Bits acceptDocs) throws IOException {
            if (twoPhase == null) {
                int doc2 = iterator2.nextDoc();
                while (doc2 != Integer.MAX_VALUE) {
                    if (acceptDocs == null || acceptDocs.get(doc2)) {
                        collector.collect(doc2);
                    }
                    doc2 = iterator2.nextDoc();
                }
            } else {
                DocIdSetIterator approximation = twoPhase.approximation();
                int doc3 = approximation.nextDoc();
                while (doc3 != Integer.MAX_VALUE) {
                    if ((acceptDocs == null || acceptDocs.get(doc3)) && twoPhase.matches()) {
                        collector.collect(doc3);
                    }
                    doc3 = approximation.nextDoc();
                }
            }
        }
    }
}

