/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.NumericUtils;

public class SortedNumericSelector {
    public static NumericDocValues wrap(SortedNumericDocValues sortedNumeric, Type selector, SortField.Type numericType) {
        NumericDocValues view;
        if (numericType != SortField.Type.INT && numericType != SortField.Type.LONG && numericType != SortField.Type.FLOAT && numericType != SortField.Type.DOUBLE) {
            throw new IllegalArgumentException("numericType must be a numeric type");
        }
        NumericDocValues singleton = DocValues.unwrapSingleton(sortedNumeric);
        if (singleton != null) {
            view = singleton;
        } else {
            switch (selector) {
                case MIN: {
                    view = new MinValue(sortedNumeric);
                    break;
                }
                case MAX: {
                    view = new MaxValue(sortedNumeric);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        switch (numericType) {
            case FLOAT: {
                return new NumericDocValues(){

                    @Override
                    public long get(int docID) {
                        return NumericUtils.sortableFloatBits((int)view.get(docID));
                    }
                };
            }
            case DOUBLE: {
                return new NumericDocValues(){

                    @Override
                    public long get(int docID) {
                        return NumericUtils.sortableDoubleBits(view.get(docID));
                    }
                };
            }
        }
        return view;
    }

    static class MaxValue
    extends NumericDocValues {
        final SortedNumericDocValues in;

        MaxValue(SortedNumericDocValues in2) {
            this.in = in2;
        }

        @Override
        public long get(int docID) {
            this.in.setDocument(docID);
            int count2 = this.in.count();
            if (count2 == 0) {
                return 0L;
            }
            return this.in.valueAt(count2 - 1);
        }
    }

    static class MinValue
    extends NumericDocValues {
        final SortedNumericDocValues in;

        MinValue(SortedNumericDocValues in2) {
            this.in = in2;
        }

        @Override
        public long get(int docID) {
            this.in.setDocument(docID);
            if (this.in.count() == 0) {
                return 0L;
            }
            return this.in.valueAt(0);
        }
    }

    public static enum Type {
        MIN,
        MAX;

    }
}

