/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automaton;

public class PrefixQuery
extends AutomatonQuery {
    public PrefixQuery(Term prefix) {
        super(prefix, PrefixQuery.toAutomaton(prefix.bytes()), Integer.MAX_VALUE, true);
        if (prefix == null) {
            throw new NullPointerException("prefix cannot be null");
        }
    }

    public static Automaton toAutomaton(BytesRef prefix) {
        Automaton automaton = new Automaton();
        int lastState = automaton.createState();
        for (int i = 0; i < prefix.length; ++i) {
            int state = automaton.createState();
            automaton.addTransition(lastState, state, prefix.bytes[prefix.offset + i] & 0xFF);
            lastState = state;
        }
        automaton.setAccept(lastState, true);
        automaton.addTransition(lastState, lastState, 0, 255);
        automaton.finishState();
        assert (automaton.isDeterministic());
        return automaton;
    }

    public Term getPrefix() {
        return this.term;
    }

    @Override
    public String toString(String field2) {
        StringBuilder buffer = new StringBuilder();
        if (!this.getField().equals(field2)) {
            buffer.append(this.getField());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        buffer.append('*');
        return buffer.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.term.hashCode();
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        PrefixQuery other2 = (PrefixQuery)obj;
        return this.term.equals(other2.term);
    }
}

