/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class Multiset<T>
extends AbstractCollection<T> {
    private final Map<T, Integer> map = new HashMap<T, Integer>();
    private int size;

    Multiset() {
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<Map.Entry<T, Integer>> mapIterator = this.map.entrySet().iterator();
        return new Iterator<T>(){
            T current;
            int remaining;

            @Override
            public boolean hasNext() {
                return this.remaining > 0 || mapIterator.hasNext();
            }

            @Override
            public T next() {
                if (this.remaining == 0) {
                    Map.Entry next2 = (Map.Entry)mapIterator.next();
                    this.current = next2.getKey();
                    this.remaining = (Integer)next2.getValue();
                }
                assert (this.remaining > 0);
                --this.remaining;
                return this.current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.map.clear();
        this.size = 0;
    }

    @Override
    public boolean add(T e) {
        Integer currentFreq = this.map.get(e);
        if (currentFreq == null) {
            this.map.put(e, 1);
        } else {
            this.map.put(e, this.map.get(e) + 1);
        }
        ++this.size;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        Integer count2 = this.map.get(o);
        if (count2 == null) {
            return false;
        }
        if (1 == count2) {
            this.map.remove(o);
        } else {
            this.map.put(o, count2 - 1);
        }
        --this.size;
        return true;
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Multiset that = (Multiset)obj;
        return this.size == that.size && this.map.equals(that.map);
    }

    @Override
    public int hashCode() {
        return 31 * this.getClass().hashCode() + this.map.hashCode();
    }
}

