/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FakeScorer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;

public final class MatchAllDocsQuery
extends Query {
    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) {
        return new ConstantScoreWeight(this){

            public String toString() {
                return "weight(" + MatchAllDocsQuery.this + ")";
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                return new ConstantScoreScorer((Weight)this, this.score(), DocIdSetIterator.all(context.reader().maxDoc()));
            }

            @Override
            public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
                final float score = this.score();
                final int maxDoc = context.reader().maxDoc();
                return new BulkScorer(){

                    @Override
                    public int score(LeafCollector collector, Bits acceptDocs, int min2, int max2) throws IOException {
                        max2 = Math.min(max2, maxDoc);
                        FakeScorer scorer = new FakeScorer();
                        scorer.score = score;
                        collector.setScorer(scorer);
                        for (int doc2 = min2; doc2 < max2; ++doc2) {
                            scorer.doc = doc2;
                            if (acceptDocs != null && !acceptDocs.get(doc2)) continue;
                            collector.collect(doc2);
                        }
                        return max2 == maxDoc ? Integer.MAX_VALUE : max2;
                    }

                    @Override
                    public long cost() {
                        return maxDoc;
                    }
                };
            }
        };
    }

    @Override
    public String toString(String field2) {
        return "*:*" + ToStringUtils.boost(this.getBoost());
    }
}

