/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;

@Deprecated
public class FilteredQuery
extends Query {
    private final Query query;
    private final Filter filter;
    private final FilterStrategy strategy;
    public static final FilterStrategy RANDOM_ACCESS_FILTER_STRATEGY = new RandomAccessFilterStrategy();
    public static final FilterStrategy LEAP_FROG_FILTER_FIRST_STRATEGY;
    public static final FilterStrategy LEAP_FROG_QUERY_FIRST_STRATEGY;
    public static final FilterStrategy QUERY_FIRST_FILTER_STRATEGY;

    public FilteredQuery(Query query, Filter filter2) {
        this(query, filter2, RANDOM_ACCESS_FILTER_STRATEGY);
    }

    public FilteredQuery(Query query, Filter filter2, FilterStrategy strategy) {
        this.strategy = Objects.requireNonNull(strategy, "FilterStrategy must not be null");
        this.query = Objects.requireNonNull(query, "Query must not be null");
        this.filter = Objects.requireNonNull(filter2, "Filter must not be null");
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.getBoost() != 1.0f) {
            return super.rewrite(reader);
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(this.query, BooleanClause.Occur.MUST);
        builder.add(this.strategy.rewrite(this.filter), BooleanClause.Occur.FILTER);
        return builder.build();
    }

    public final Query getQuery() {
        return this.query;
    }

    public final Filter getFilter() {
        return this.filter;
    }

    public FilterStrategy getFilterStrategy() {
        return this.strategy;
    }

    @Override
    public String toString(String s2) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("filtered(");
        buffer.append(this.query.toString(s2));
        buffer.append(")->");
        buffer.append(this.filter);
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        assert (o instanceof FilteredQuery);
        FilteredQuery fq = (FilteredQuery)o;
        return fq.query.equals(this.query) && fq.filter.equals(this.filter) && fq.strategy.equals(this.strategy);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = hash * 31 + this.strategy.hashCode();
        hash = hash * 31 + this.query.hashCode();
        hash = hash * 31 + this.filter.hashCode();
        return hash;
    }

    static {
        LEAP_FROG_QUERY_FIRST_STRATEGY = LEAP_FROG_FILTER_FIRST_STRATEGY = new RandomAccessFilterStrategy(){

            @Override
            protected boolean useRandomAccess(Bits bits2, long filterCost) {
                return false;
            }
        };
        QUERY_FIRST_FILTER_STRATEGY = new RandomAccessFilterStrategy(){

            @Override
            boolean alwaysUseRandomAccess() {
                return true;
            }
        };
    }

    private static class RandomAccessFilterWrapperQuery
    extends Query {
        final Filter filter;
        final RandomAccessFilterStrategy strategy;

        private RandomAccessFilterWrapperQuery(Filter filter2, RandomAccessFilterStrategy strategy) {
            this.filter = Objects.requireNonNull(filter2);
            this.strategy = Objects.requireNonNull(strategy);
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            RandomAccessFilterWrapperQuery that = (RandomAccessFilterWrapperQuery)obj;
            return this.filter.equals(that.filter) && this.strategy.equals(that.strategy);
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + Objects.hash(this.filter, this.strategy);
        }

        @Override
        public String toString(String field2) {
            return this.filter.toString(field2);
        }

        @Override
        public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
            return new Weight(this){

                @Override
                public void extractTerms(Set<Term> terms) {
                }

                @Override
                public float getValueForNormalization() throws IOException {
                    return 0.0f;
                }

                @Override
                public void normalize(float norm, float topLevelBoost) {
                }

                @Override
                public Explanation explain(LeafReaderContext context, int doc2) throws IOException {
                    boolean match;
                    Scorer s2 = this.scorer(context);
                    if (s2 == null) {
                        match = false;
                    } else {
                        TwoPhaseIterator twoPhase = s2.twoPhaseIterator();
                        if (twoPhase == null) {
                            match = s2.iterator().advance(doc2) == doc2;
                        } else {
                            boolean bl = match = twoPhase.approximation().advance(doc2) == doc2 && twoPhase.matches();
                        }
                    }
                    if (match) {
                        assert (s2.score() == 0.0f);
                        return Explanation.match(0.0f, "Match on id " + doc2, new Explanation[0]);
                    }
                    return Explanation.match(0.0f, "No match on id " + doc2, new Explanation[0]);
                }

                @Override
                public Scorer scorer(LeafReaderContext context) throws IOException {
                    DocIdSetIterator iterator2;
                    boolean useRandomAccess;
                    DocIdSet set = RandomAccessFilterWrapperQuery.this.filter.getDocIdSet(context, null);
                    if (set == null) {
                        return null;
                    }
                    final Bits bits2 = set.bits();
                    boolean bl = useRandomAccess = bits2 != null && RandomAccessFilterWrapperQuery.this.strategy.alwaysUseRandomAccess();
                    if (useRandomAccess) {
                        iterator2 = null;
                    } else {
                        iterator2 = set.iterator();
                        if (iterator2 == null) {
                            return null;
                        }
                        if (bits2 != null) {
                            useRandomAccess = RandomAccessFilterWrapperQuery.this.strategy.useRandomAccess(bits2, iterator2.cost());
                        }
                    }
                    if (useRandomAccess) {
                        DocIdSetIterator approximation = DocIdSetIterator.all(context.reader().maxDoc());
                        TwoPhaseIterator twoPhase = new TwoPhaseIterator(approximation){

                            @Override
                            public boolean matches() throws IOException {
                                int doc2 = this.approximation.docID();
                                return bits2.get(doc2);
                            }

                            @Override
                            public float matchCost() {
                                return 10.0f;
                            }
                        };
                        return new ConstantScoreScorer((Weight)this, 0.0f, twoPhase);
                    }
                    return new ConstantScoreScorer((Weight)this, 0.0f, iterator2);
                }
            };
        }
    }

    public static class RandomAccessFilterStrategy
    extends FilterStrategy {
        @Override
        public Query rewrite(Filter filter2) {
            return new RandomAccessFilterWrapperQuery(filter2, this);
        }

        protected boolean useRandomAccess(Bits bits2, long filterCost) {
            return filterCost * 100L > (long)bits2.length();
        }

        boolean alwaysUseRandomAccess() {
            return false;
        }
    }

    public static abstract class FilterStrategy {
        public abstract Query rewrite(Filter var1);
    }
}

