/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.lucene.search.DisiWrapper;

public final class DisiPriorityQueue
implements Iterable<DisiWrapper> {
    private final DisiWrapper[] heap;
    private int size;

    static int leftNode(int node) {
        return (node + 1 << 1) - 1;
    }

    static int rightNode(int leftNode) {
        return leftNode + 1;
    }

    static int parentNode(int node) {
        return (node + 1 >>> 1) - 1;
    }

    public DisiPriorityQueue(int maxSize) {
        this.heap = new DisiWrapper[maxSize];
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public DisiWrapper top() {
        return this.heap[0];
    }

    public DisiWrapper topList() {
        DisiWrapper[] heap = this.heap;
        int size2 = this.size;
        DisiWrapper list2 = heap[0];
        list2.next = null;
        if (size2 >= 3) {
            list2 = this.topList(list2, heap, size2, 1);
            list2 = this.topList(list2, heap, size2, 2);
        } else if (size2 == 2 && heap[1].doc == list2.doc) {
            list2 = this.prepend(heap[1], list2);
        }
        return list2;
    }

    private DisiWrapper prepend(DisiWrapper w1, DisiWrapper w2) {
        w1.next = w2;
        return w1;
    }

    private DisiWrapper topList(DisiWrapper list2, DisiWrapper[] heap, int size2, int i) {
        DisiWrapper w = heap[i];
        if (w.doc == list2.doc) {
            list2 = this.prepend(w, list2);
            int left2 = DisiPriorityQueue.leftNode(i);
            int right2 = left2 + 1;
            if (right2 < size2) {
                list2 = this.topList(list2, heap, size2, left2);
                list2 = this.topList(list2, heap, size2, right2);
            } else if (left2 < size2 && heap[left2].doc == list2.doc) {
                list2 = this.prepend(heap[left2], list2);
            }
        }
        return list2;
    }

    public DisiWrapper add(DisiWrapper entry) {
        DisiWrapper[] heap = this.heap;
        int size2 = this.size;
        heap[size2] = entry;
        this.upHeap(size2);
        this.size = size2 + 1;
        return heap[0];
    }

    public DisiWrapper pop() {
        DisiWrapper[] heap = this.heap;
        DisiWrapper result2 = heap[0];
        int i = --this.size;
        heap[0] = heap[i];
        heap[i] = null;
        this.downHeap(i);
        return result2;
    }

    public DisiWrapper updateTop() {
        this.downHeap(this.size);
        return this.heap[0];
    }

    DisiWrapper updateTop(DisiWrapper topReplacement) {
        this.heap[0] = topReplacement;
        return this.updateTop();
    }

    void upHeap(int i) {
        DisiWrapper node = this.heap[i];
        int nodeDoc = node.doc;
        int j = DisiPriorityQueue.parentNode(i);
        while (j >= 0 && nodeDoc < this.heap[j].doc) {
            this.heap[i] = this.heap[j];
            i = j;
            j = DisiPriorityQueue.parentNode(j);
        }
        this.heap[i] = node;
    }

    void downHeap(int size2) {
        int i = 0;
        DisiWrapper node = this.heap[0];
        int j = DisiPriorityQueue.leftNode(i);
        if (j < size2) {
            int k = DisiPriorityQueue.rightNode(j);
            if (k < size2 && this.heap[k].doc < this.heap[j].doc) {
                j = k;
            }
            if (this.heap[j].doc < node.doc) {
                do {
                    this.heap[i] = this.heap[j];
                    i = j;
                    k = DisiPriorityQueue.rightNode(j = DisiPriorityQueue.leftNode(i));
                    if (k >= size2 || this.heap[k].doc >= this.heap[j].doc) continue;
                    j = k;
                } while (j < size2 && this.heap[j].doc < node.doc);
                this.heap[i] = node;
            }
        }
    }

    @Override
    public Iterator<DisiWrapper> iterator() {
        return Arrays.asList(this.heap).subList(0, this.size).iterator();
    }
}

