/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

public abstract class ConstantScoreWeight
extends Weight {
    private float boost;
    private float queryNorm;
    private float queryWeight;

    protected ConstantScoreWeight(Query query) {
        super(query);
        this.normalize(1.0f, 1.0f);
    }

    @Override
    public void extractTerms(Set<Term> terms) {
    }

    @Override
    public final float getValueForNormalization() throws IOException {
        return this.queryWeight * this.queryWeight;
    }

    @Override
    public void normalize(float norm, float boost) {
        this.boost = boost;
        this.queryNorm = norm;
        this.queryWeight = this.queryNorm * boost;
    }

    protected final float queryNorm() {
        return this.queryNorm;
    }

    protected final float boost() {
        return this.boost;
    }

    protected final float score() {
        return this.queryWeight;
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc2) throws IOException {
        boolean exists2;
        Scorer s2 = this.scorer(context);
        if (s2 == null) {
            exists2 = false;
        } else {
            TwoPhaseIterator twoPhase = s2.twoPhaseIterator();
            if (twoPhase == null) {
                exists2 = s2.iterator().advance(doc2) == doc2;
            } else {
                boolean bl = exists2 = twoPhase.approximation().advance(doc2) == doc2 && twoPhase.matches();
            }
        }
        if (exists2) {
            return Explanation.match(this.queryWeight, this.getQuery().toString() + ", product of:", Explanation.match(this.boost, "boost", new Explanation[0]), Explanation.match(this.queryNorm, "queryNorm", new Explanation[0]));
        }
        return Explanation.noMatch(this.getQuery().toString() + " doesn't match id " + doc2, new Explanation[0]);
    }
}

