/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.search.ConjunctionDISI;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

class ConjunctionScorer
extends Scorer {
    final ConjunctionDISI disi;
    final Scorer[] scorers;
    final float coord;

    ConjunctionScorer(Weight weight, List<Scorer> required, List<Scorer> scorers) {
        this(weight, required, scorers, 1.0f);
    }

    ConjunctionScorer(Weight weight, List<Scorer> required, List<Scorer> scorers, float coord) {
        super(weight);
        assert (required.containsAll(scorers));
        this.coord = coord;
        this.disi = ConjunctionDISI.intersectScorers(required);
        this.scorers = scorers.toArray(new Scorer[scorers.size()]);
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        return this.disi.asTwoPhaseIterator();
    }

    @Override
    public DocIdSetIterator iterator() {
        return this.disi;
    }

    @Override
    public int docID() {
        return this.disi.docID();
    }

    @Override
    public float score() throws IOException {
        double sum2 = 0.0;
        for (Scorer scorer : this.scorers) {
            sum2 += (double)scorer.score();
        }
        return this.coord * (float)sum2;
    }

    @Override
    public int freq() {
        return this.scorers.length;
    }

    @Override
    public Collection<Scorer.ChildScorer> getChildren() {
        ArrayList<Scorer.ChildScorer> children2 = new ArrayList<Scorer.ChildScorer>();
        for (Scorer scorer : this.scorers) {
            children2.add(new Scorer.ChildScorer(scorer, "MUST"));
        }
        return children2;
    }

    static final class DocsAndFreqs {
        final long cost;
        final DocIdSetIterator iterator;
        int doc = -1;

        DocsAndFreqs(DocIdSetIterator iterator2) {
            this.iterator = iterator2;
            this.cost = iterator2.cost();
        }
    }
}

