/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilterCachingPolicy;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.RoaringDocIdSet;

@Deprecated
public class CachingWrapperFilter
extends Filter
implements Accountable {
    private final Filter filter;
    private final FilterCachingPolicy policy;
    private final Map<Object, DocIdSet> cache = Collections.synchronizedMap(new WeakHashMap());
    int hitCount;
    int missCount;

    public CachingWrapperFilter(Filter filter2, FilterCachingPolicy policy) {
        this.filter = filter2;
        this.policy = policy;
    }

    public CachingWrapperFilter(Filter filter2) {
        this(filter2, FilterCachingPolicy.CacheOnLargeSegments.DEFAULT);
    }

    public Filter getFilter() {
        return this.filter;
    }

    protected DocIdSet docIdSetToCache(DocIdSet docIdSet, LeafReader reader) throws IOException {
        if (docIdSet == null || docIdSet.isCacheable()) {
            return docIdSet;
        }
        DocIdSetIterator it = docIdSet.iterator();
        if (it == null) {
            return null;
        }
        return this.cacheImpl(it, reader);
    }

    protected DocIdSet cacheImpl(DocIdSetIterator iterator2, LeafReader reader) throws IOException {
        return new RoaringDocIdSet.Builder(reader.maxDoc()).add(iterator2).build();
    }

    @Override
    public DocIdSet getDocIdSet(LeafReaderContext context, Bits acceptDocs) throws IOException {
        LeafReader reader = context.reader();
        Object key = reader.getCoreCacheKey();
        DocIdSet docIdSet = this.cache.get(key);
        if (docIdSet != null) {
            ++this.hitCount;
        } else {
            docIdSet = this.filter.getDocIdSet(context, null);
            if (this.policy.shouldCache(this.filter, context, docIdSet)) {
                ++this.missCount;
                if ((docIdSet = this.docIdSetToCache(docIdSet, reader)) == null) {
                    docIdSet = DocIdSet.EMPTY;
                }
                assert (docIdSet.isCacheable());
                this.cache.put(key, docIdSet);
            }
        }
        return docIdSet == DocIdSet.EMPTY ? null : BitsFilteredDocIdSet.wrap(docIdSet, acceptDocs);
    }

    @Override
    public String toString(String field2) {
        return this.getClass().getSimpleName() + "(" + this.filter.toString(field2) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        CachingWrapperFilter other2 = (CachingWrapperFilter)o;
        return this.filter.equals(other2.filter);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.filter.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long ramBytesUsed() {
        ArrayList<DocIdSet> docIdSets;
        Map<Object, DocIdSet> map2 = this.cache;
        synchronized (map2) {
            docIdSets = new ArrayList<DocIdSet>(this.cache.values());
        }
        long total2 = 0L;
        for (DocIdSet dis : docIdSets) {
            total2 += dis.ramBytesUsed();
        }
        return total2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Accountable> getChildResources() {
        Map<Object, DocIdSet> map2 = this.cache;
        synchronized (map2) {
            return Accountables.namedAccountables("segment", this.cache);
        }
    }
}

