/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FilterCollector;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.util.ArrayUtil;

public abstract class CachingCollector
extends FilterCollector {
    private static final int INITIAL_ARRAY_SIZE = 128;
    private boolean cached = true;

    public static CachingCollector create(boolean cacheScores, double maxRAMMB) {
        SimpleCollector other2 = new SimpleCollector(){

            @Override
            public void collect(int doc2) {
            }

            @Override
            public boolean needsScores() {
                return true;
            }
        };
        return CachingCollector.create((Collector)other2, cacheScores, maxRAMMB);
    }

    public static CachingCollector create(Collector other2, boolean cacheScores, double maxRAMMB) {
        int bytesPerDoc = 4;
        if (cacheScores) {
            bytesPerDoc += 4;
        }
        int maxDocsToCache = (int)(maxRAMMB * 1024.0 * 1024.0 / (double)bytesPerDoc);
        return CachingCollector.create(other2, cacheScores, maxDocsToCache);
    }

    public static CachingCollector create(Collector other2, boolean cacheScores, int maxDocsToCache) {
        return cacheScores ? new ScoreCachingCollector(other2, maxDocsToCache) : new NoScoreCachingCollector(other2, maxDocsToCache);
    }

    private CachingCollector(Collector in2) {
        super(in2);
    }

    public final boolean isCached() {
        return this.cached;
    }

    public abstract void replay(Collector var1) throws IOException;

    private class ScoreCachingLeafCollector
    extends NoScoreCachingLeafCollector {
        Scorer scorer;
        float[] scores;

        ScoreCachingLeafCollector(LeafCollector in2, int maxDocsToCache) {
            super(in2, maxDocsToCache);
            this.scores = new float[this.docs.length];
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
            super.setScorer(scorer);
        }

        @Override
        protected void grow(int newLen) {
            super.grow(newLen);
            this.scores = Arrays.copyOf(this.scores, newLen);
        }

        @Override
        protected void invalidate() {
            super.invalidate();
            this.scores = null;
        }

        @Override
        protected void buffer(int doc2) throws IOException {
            super.buffer(doc2);
            this.scores[this.docCount] = this.scorer.score();
        }

        float[] cachedScores() {
            return this.docs == null ? null : Arrays.copyOf(this.scores, this.docCount);
        }
    }

    private class NoScoreCachingLeafCollector
    extends FilterLeafCollector {
        final int maxDocsToCache;
        int[] docs;
        int docCount;

        NoScoreCachingLeafCollector(LeafCollector in2, int maxDocsToCache) {
            super(in2);
            this.maxDocsToCache = maxDocsToCache;
            this.docs = new int[Math.min(maxDocsToCache, 128)];
            this.docCount = 0;
        }

        protected void grow(int newLen) {
            this.docs = Arrays.copyOf(this.docs, newLen);
        }

        protected void invalidate() {
            this.docs = null;
            this.docCount = -1;
            CachingCollector.this.cached = false;
        }

        protected void buffer(int doc2) throws IOException {
            this.docs[this.docCount] = doc2;
        }

        @Override
        public void collect(int doc2) throws IOException {
            if (this.docs != null) {
                if (this.docCount >= this.docs.length) {
                    if (this.docCount >= this.maxDocsToCache) {
                        this.invalidate();
                    } else {
                        int newLen = Math.min(ArrayUtil.oversize(this.docCount + 1, 4), this.maxDocsToCache);
                        this.grow(newLen);
                    }
                }
                if (this.docs != null) {
                    this.buffer(doc2);
                    ++this.docCount;
                }
            }
            super.collect(doc2);
        }

        boolean hasCache() {
            return this.docs != null;
        }

        int[] cachedDocs() {
            return this.docs == null ? null : Arrays.copyOf(this.docs, this.docCount);
        }
    }

    private static class ScoreCachingCollector
    extends NoScoreCachingCollector {
        List<float[]> scores = new ArrayList<float[]>();

        ScoreCachingCollector(Collector in2, int maxDocsToCache) {
            super(in2, maxDocsToCache);
        }

        @Override
        protected NoScoreCachingLeafCollector wrap(LeafCollector in2, int maxDocsToCache) {
            return new ScoreCachingLeafCollector(in2, maxDocsToCache);
        }

        @Override
        protected void postCollect(NoScoreCachingLeafCollector collector) {
            ScoreCachingLeafCollector coll = (ScoreCachingLeafCollector)collector;
            super.postCollect(coll);
            this.scores.add(coll.cachedScores());
        }

        @Override
        public boolean needsScores() {
            return true;
        }

        @Override
        protected void collect(LeafCollector collector, int i) throws IOException {
            int[] docs = (int[])this.docs.get(i);
            float[] scores = this.scores.get(i);
            assert (docs.length == scores.length);
            CachedScorer scorer = new CachedScorer();
            collector.setScorer(scorer);
            for (int j = 0; j < docs.length; ++j) {
                scorer.doc = docs[j];
                scorer.score = scores[j];
                collector.collect(scorer.doc);
            }
        }
    }

    private static class NoScoreCachingCollector
    extends CachingCollector {
        List<LeafReaderContext> contexts;
        List<int[]> docs;
        int maxDocsToCache;
        NoScoreCachingLeafCollector lastCollector;

        NoScoreCachingCollector(Collector in2, int maxDocsToCache) {
            super(in2);
            this.maxDocsToCache = maxDocsToCache;
            this.contexts = new ArrayList<LeafReaderContext>();
            this.docs = new ArrayList<int[]>();
        }

        protected NoScoreCachingLeafCollector wrap(LeafCollector in2, int maxDocsToCache) {
            return new NoScoreCachingLeafCollector(in2, maxDocsToCache);
        }

        @Override
        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            this.postCollection();
            LeafCollector in2 = this.in.getLeafCollector(context);
            if (this.contexts != null) {
                this.contexts.add(context);
            }
            if (this.maxDocsToCache >= 0) {
                this.lastCollector = this.wrap(in2, this.maxDocsToCache);
                return this.lastCollector;
            }
            return in2;
        }

        protected void invalidate() {
            this.maxDocsToCache = -1;
            this.contexts = null;
            this.docs = null;
        }

        protected void postCollect(NoScoreCachingLeafCollector collector) {
            int[] docs = collector.cachedDocs();
            this.maxDocsToCache -= docs.length;
            this.docs.add(docs);
        }

        private void postCollection() {
            if (this.lastCollector != null) {
                if (!this.lastCollector.hasCache()) {
                    this.invalidate();
                } else {
                    this.postCollect(this.lastCollector);
                }
                this.lastCollector = null;
            }
        }

        protected void collect(LeafCollector collector, int i) throws IOException {
            int[] docs;
            for (int doc2 : docs = this.docs.get(i)) {
                collector.collect(doc2);
            }
        }

        @Override
        public void replay(Collector other2) throws IOException {
            this.postCollection();
            if (!this.isCached()) {
                throw new IllegalStateException("cannot replay: cache was cleared because too much RAM was required");
            }
            assert (this.docs.size() == this.contexts.size());
            for (int i = 0; i < this.contexts.size(); ++i) {
                LeafReaderContext context = this.contexts.get(i);
                LeafCollector collector = other2.getLeafCollector(context);
                this.collect(collector, i);
            }
        }
    }

    private static final class CachedScorer
    extends Scorer {
        int doc;
        float score;

        private CachedScorer() {
            super(null);
        }

        @Override
        public DocIdSetIterator iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final float score() {
            return this.score;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public final int freq() {
            throw new UnsupportedOperationException();
        }
    }
}

