/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BooleanScorer;
import org.apache.lucene.search.BooleanTopLevelScorers;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConjunctionScorer;
import org.apache.lucene.search.DisjunctionSumScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FakeScorer;
import org.apache.lucene.search.FilterScorer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.MinShouldMatchSumScorer;
import org.apache.lucene.search.ReqExclBulkScorer;
import org.apache.lucene.search.ReqExclScorer;
import org.apache.lucene.search.ReqOptSumScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.Bits;

final class BooleanWeight
extends Weight {
    final Similarity similarity;
    final BooleanQuery query;
    final ArrayList<Weight> weights;
    final int maxCoord;
    final boolean disableCoord;
    final boolean needsScores;
    final float[] coords;

    BooleanWeight(BooleanQuery query, IndexSearcher searcher, boolean needsScores, boolean disableCoord) throws IOException {
        super(query);
        this.query = query;
        this.needsScores = needsScores;
        this.similarity = searcher.getSimilarity(needsScores);
        this.weights = new ArrayList();
        int i = 0;
        int maxCoord = 0;
        for (BooleanClause c : query) {
            Weight w = searcher.createWeight(c.getQuery(), needsScores && c.isScoring());
            this.weights.add(w);
            if (c.isScoring()) {
                ++maxCoord;
            }
            ++i;
        }
        this.maxCoord = maxCoord;
        this.coords = new float[maxCoord + 1];
        Arrays.fill(this.coords, 1.0f);
        this.coords[0] = 0.0f;
        if (maxCoord > 0 && needsScores && !disableCoord) {
            boolean seenActualCoord = false;
            for (i = 1; i < this.coords.length; ++i) {
                this.coords[i] = this.coord(i, maxCoord);
                seenActualCoord |= this.coords[i] != 1.0f;
            }
            this.disableCoord = !seenActualCoord;
        } else {
            this.disableCoord = true;
        }
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        int i = 0;
        for (BooleanClause clause : this.query) {
            if (clause.isScoring() || !this.needsScores && !clause.isProhibited()) {
                this.weights.get(i).extractTerms(terms);
            }
            ++i;
        }
    }

    @Override
    public float getValueForNormalization() throws IOException {
        float sum2 = 0.0f;
        int i = 0;
        for (BooleanClause clause : this.query) {
            float s2 = this.weights.get(i).getValueForNormalization();
            if (clause.isScoring()) {
                sum2 += s2;
            }
            ++i;
        }
        return sum2;
    }

    public float coord(int overlap, int maxOverlap) {
        if (overlap == 0) {
            return 0.0f;
        }
        if (maxOverlap == 1) {
            return 1.0f;
        }
        return this.similarity.coord(overlap, maxOverlap);
    }

    @Override
    public void normalize(float norm, float boost) {
        for (Weight w : this.weights) {
            w.normalize(norm, boost);
        }
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc2) throws IOException {
        float coordFactor;
        int minShouldMatch = this.query.getMinimumNumberShouldMatch();
        ArrayList<Explanation> subs = new ArrayList<Explanation>();
        int coord = 0;
        float sum2 = 0.0f;
        boolean fail2 = false;
        int matchCount = 0;
        int shouldMatchCount = 0;
        Iterator<BooleanClause> cIter = this.query.iterator();
        for (Weight w : this.weights) {
            BooleanClause c = cIter.next();
            Explanation e = w.explain(context, doc2);
            if (e.isMatch()) {
                if (c.isScoring()) {
                    subs.add(e);
                    sum2 += e.getValue();
                    ++coord;
                } else if (c.isRequired()) {
                    subs.add(Explanation.match(0.0f, "match on required clause, product of:", Explanation.match(0.0f, (Object)((Object)BooleanClause.Occur.FILTER) + " clause", new Explanation[0]), e));
                } else if (c.isProhibited()) {
                    subs.add(Explanation.noMatch("match on prohibited clause (" + c.getQuery().toString() + ")", e));
                    fail2 = true;
                }
                if (!c.isProhibited()) {
                    ++matchCount;
                }
                if (c.getOccur() != BooleanClause.Occur.SHOULD) continue;
                ++shouldMatchCount;
                continue;
            }
            if (!c.isRequired()) continue;
            subs.add(Explanation.noMatch("no match on required clause (" + c.getQuery().toString() + ")", e));
            fail2 = true;
        }
        if (fail2) {
            return Explanation.noMatch("Failure to meet condition(s) of required/prohibited clause(s)", subs);
        }
        if (matchCount == 0) {
            return Explanation.noMatch("No matching clauses", subs);
        }
        if (shouldMatchCount < minShouldMatch) {
            return Explanation.noMatch("Failure to match minimum number of optional clauses: " + minShouldMatch, subs);
        }
        Explanation result2 = Explanation.match(sum2, "sum of:", subs);
        float f = coordFactor = this.disableCoord ? 1.0f : this.coord(coord, this.maxCoord);
        if (coordFactor != 1.0f) {
            result2 = Explanation.match(sum2 * coordFactor, "product of:", result2, Explanation.match(coordFactor, "coord(" + coord + "/" + this.maxCoord + ")", new Explanation[0]));
        }
        return result2;
    }

    static BulkScorer disableScoring(final BulkScorer scorer) {
        return new BulkScorer(){

            @Override
            public int score(final LeafCollector collector, Bits acceptDocs, int min2, int max2) throws IOException {
                LeafCollector noScoreCollector = new LeafCollector(){
                    FakeScorer fake = new FakeScorer();

                    @Override
                    public void setScorer(Scorer scorer) throws IOException {
                        collector.setScorer(this.fake);
                    }

                    @Override
                    public void collect(int doc2) throws IOException {
                        this.fake.doc = doc2;
                        collector.collect(doc2);
                    }
                };
                return scorer.score(noScoreCollector, acceptDocs, min2, max2);
            }

            @Override
            public long cost() {
                return scorer.cost();
            }
        };
    }

    BulkScorer optionalBulkScorer(LeafReaderContext context) throws IOException {
        ArrayList<BulkScorer> optional2 = new ArrayList<BulkScorer>();
        Iterator<BooleanClause> cIter = this.query.iterator();
        for (Weight w : this.weights) {
            BulkScorer subScorer;
            BooleanClause c = cIter.next();
            if (c.getOccur() != BooleanClause.Occur.SHOULD || (subScorer = w.bulkScorer(context)) == null) continue;
            optional2.add(subScorer);
        }
        if (optional2.size() == 0) {
            return null;
        }
        if (this.query.getMinimumNumberShouldMatch() > optional2.size()) {
            return null;
        }
        if (optional2.size() == 1) {
            BulkScorer opt2 = (BulkScorer)optional2.get(0);
            if (!this.disableCoord && this.maxCoord > 1) {
                return new BooleanTopLevelScorers.BoostedBulkScorer(opt2, this.coord(1, this.maxCoord));
            }
            return opt2;
        }
        return new BooleanScorer(this, this.disableCoord, this.maxCoord, optional2, Math.max(1, this.query.getMinimumNumberShouldMatch()), this.needsScores);
    }

    private BulkScorer requiredBulkScorer(LeafReaderContext context) throws IOException {
        BulkScorer scorer = null;
        Iterator<BooleanClause> cIter = this.query.iterator();
        for (Weight w : this.weights) {
            BooleanClause c = cIter.next();
            if (!c.isRequired()) continue;
            if (scorer != null) {
                return null;
            }
            scorer = w.bulkScorer(context);
            if (scorer == null) {
                return null;
            }
            if (!c.isScoring()) {
                if (!this.needsScores) continue;
                scorer = BooleanWeight.disableScoring(scorer);
                continue;
            }
            assert (this.maxCoord == 1);
        }
        return scorer;
    }

    BulkScorer booleanScorer(LeafReaderContext context) throws IOException {
        BulkScorer positiveScorer;
        int numOptionalClauses = this.query.getClauses(BooleanClause.Occur.SHOULD).size();
        int numRequiredClauses = this.query.getClauses(BooleanClause.Occur.MUST).size() + this.query.getClauses(BooleanClause.Occur.FILTER).size();
        if (numRequiredClauses == 0) {
            positiveScorer = this.optionalBulkScorer(context);
            if (positiveScorer == null) {
                return null;
            }
            long costThreshold = this.query.getMinimumNumberShouldMatch() <= 1 ? -1L : (long)(context.reader().maxDoc() / 3);
            if (positiveScorer.cost() < costThreshold) {
                return null;
            }
        } else if (numRequiredClauses == 1 && numOptionalClauses == 0 && this.query.getMinimumNumberShouldMatch() == 0) {
            positiveScorer = this.requiredBulkScorer(context);
        } else {
            return null;
        }
        if (positiveScorer == null) {
            return null;
        }
        ArrayList<Scorer> prohibited = new ArrayList<Scorer>();
        Iterator<BooleanClause> cIter = this.query.iterator();
        for (Weight w : this.weights) {
            Scorer scorer;
            BooleanClause c = cIter.next();
            if (!c.isProhibited() || (scorer = w.scorer(context)) == null) continue;
            prohibited.add(scorer);
        }
        if (prohibited.isEmpty()) {
            return positiveScorer;
        }
        Scorer prohibitedScorer = this.opt(prohibited, 1, true);
        if (prohibitedScorer.twoPhaseIterator() != null) {
            return null;
        }
        return new ReqExclBulkScorer(positiveScorer, prohibitedScorer.iterator());
    }

    @Override
    public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
        BulkScorer bulkScorer = this.booleanScorer(context);
        if (bulkScorer != null) {
            return bulkScorer;
        }
        return super.bulkScorer(context);
    }

    @Override
    public Scorer scorer(LeafReaderContext context) throws IOException {
        int minShouldMatch = this.query.getMinimumNumberShouldMatch();
        ArrayList<Scorer> required = new ArrayList<Scorer>();
        ArrayList<Scorer> requiredScoring = new ArrayList<Scorer>();
        ArrayList<Scorer> prohibited = new ArrayList<Scorer>();
        ArrayList<Scorer> optional2 = new ArrayList<Scorer>();
        Iterator<BooleanClause> cIter = this.query.iterator();
        for (Weight w : this.weights) {
            BooleanClause c = cIter.next();
            Scorer subScorer = w.scorer(context);
            if (subScorer == null) {
                if (!c.isRequired()) continue;
                return null;
            }
            if (c.isRequired()) {
                required.add(subScorer);
                if (!c.isScoring()) continue;
                requiredScoring.add(subScorer);
                continue;
            }
            if (c.isProhibited()) {
                prohibited.add(subScorer);
                continue;
            }
            optional2.add(subScorer);
        }
        if (optional2.size() == minShouldMatch) {
            required.addAll(optional2);
            requiredScoring.addAll(optional2);
            optional2.clear();
            minShouldMatch = 0;
        }
        if (required.isEmpty() && optional2.isEmpty()) {
            return null;
        }
        if (optional2.size() < minShouldMatch) {
            return null;
        }
        if (!this.needsScores && minShouldMatch == 0 && required.size() > 0) {
            optional2.clear();
        }
        if (optional2.isEmpty()) {
            return this.excl(this.req(required, requiredScoring, this.disableCoord), prohibited);
        }
        if (required.isEmpty()) {
            return this.excl(this.opt(optional2, minShouldMatch, this.disableCoord), prohibited);
        }
        Scorer req = this.excl(this.req(required, requiredScoring, true), prohibited);
        Scorer opt2 = this.opt(optional2, minShouldMatch, true);
        if (this.disableCoord) {
            if (minShouldMatch > 0) {
                return new ConjunctionScorer(this, Arrays.asList(req, opt2), Arrays.asList(req, opt2), 1.0f);
            }
            return new ReqOptSumScorer(req, opt2);
        }
        if (optional2.size() == 1) {
            if (minShouldMatch > 0) {
                return new ConjunctionScorer(this, Arrays.asList(req, opt2), Arrays.asList(req, opt2), this.coord(requiredScoring.size() + 1, this.maxCoord));
            }
            float coordReq = this.coord(requiredScoring.size(), this.maxCoord);
            float coordBoth = this.coord(requiredScoring.size() + 1, this.maxCoord);
            return new BooleanTopLevelScorers.ReqSingleOptScorer(req, opt2, coordReq, coordBoth);
        }
        if (minShouldMatch > 0) {
            return new BooleanTopLevelScorers.CoordinatingConjunctionScorer(this, this.coords, req, requiredScoring.size(), opt2);
        }
        return new BooleanTopLevelScorers.ReqMultiOptScorer(req, opt2, requiredScoring.size(), this.coords);
    }

    private Scorer req(List<Scorer> required, List<Scorer> requiredScoring, boolean disableCoord) {
        if (required.size() == 1) {
            Scorer req = required.get(0);
            if (!this.needsScores) {
                return req;
            }
            if (requiredScoring.isEmpty()) {
                return new FilterScorer(req){

                    @Override
                    public float score() throws IOException {
                        return 0.0f;
                    }

                    @Override
                    public int freq() throws IOException {
                        return 0;
                    }
                };
            }
            float boost = 1.0f;
            if (!disableCoord) {
                boost = this.coord(1, this.maxCoord);
            }
            if (boost == 1.0f) {
                return req;
            }
            return new BooleanTopLevelScorers.BoostedScorer(req, boost);
        }
        return new ConjunctionScorer(this, required, requiredScoring, disableCoord ? 1.0f : this.coord(requiredScoring.size(), this.maxCoord));
    }

    private Scorer excl(Scorer main2, List<Scorer> prohibited) throws IOException {
        if (prohibited.isEmpty()) {
            return main2;
        }
        if (prohibited.size() == 1) {
            return new ReqExclScorer(main2, prohibited.get(0));
        }
        float[] coords = new float[prohibited.size() + 1];
        Arrays.fill(coords, 1.0f);
        return new ReqExclScorer(main2, new DisjunctionSumScorer(this, prohibited, coords, false));
    }

    private Scorer opt(List<Scorer> optional2, int minShouldMatch, boolean disableCoord) throws IOException {
        float[] coords;
        if (optional2.size() == 1) {
            Scorer opt2 = optional2.get(0);
            if (!disableCoord && this.maxCoord > 1) {
                return new BooleanTopLevelScorers.BoostedScorer(opt2, this.coord(1, this.maxCoord));
            }
            return opt2;
        }
        if (disableCoord) {
            coords = new float[optional2.size() + 1];
            Arrays.fill(coords, 1.0f);
        } else {
            coords = this.coords;
        }
        if (minShouldMatch > 1) {
            return new MinShouldMatchSumScorer(this, optional2, minShouldMatch, coords);
        }
        return new DisjunctionSumScorer(this, optional2, coords, this.needsScores);
    }
}

