/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanWeight;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Multiset;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;

public class BooleanQuery
extends Query
implements Iterable<BooleanClause> {
    private static int maxClauseCount = 1024;
    private final boolean mutable;
    private final boolean disableCoord;
    private int minimumNumberShouldMatch;
    private List<BooleanClause> clauses;
    private final Map<BooleanClause.Occur, Collection<Query>> clauseSets;
    private int hashCode;

    public static int getMaxClauseCount() {
        return maxClauseCount;
    }

    public static void setMaxClauseCount(int maxClauseCount) {
        if (maxClauseCount < 1) {
            throw new IllegalArgumentException("maxClauseCount must be >= 1");
        }
        BooleanQuery.maxClauseCount = maxClauseCount;
    }

    private BooleanQuery(boolean disableCoord, int minimumNumberShouldMatch, BooleanClause[] clauses) {
        this.disableCoord = disableCoord;
        this.minimumNumberShouldMatch = minimumNumberShouldMatch;
        this.clauses = Collections.unmodifiableList(Arrays.asList(clauses));
        this.mutable = false;
        this.clauseSets = new EnumMap<BooleanClause.Occur, Collection<Query>>(BooleanClause.Occur.class);
        this.clauseSets.put(BooleanClause.Occur.SHOULD, new Multiset());
        this.clauseSets.put(BooleanClause.Occur.MUST, new Multiset());
        this.clauseSets.put(BooleanClause.Occur.FILTER, new HashSet());
        this.clauseSets.put(BooleanClause.Occur.MUST_NOT, new HashSet());
        for (BooleanClause clause : clauses) {
            this.clauseSets.get((Object)clause.getOccur()).add(clause.getQuery());
        }
    }

    public boolean isCoordDisabled() {
        return this.disableCoord;
    }

    public int getMinimumNumberShouldMatch() {
        return this.minimumNumberShouldMatch;
    }

    public List<BooleanClause> clauses() {
        return this.clauses;
    }

    Collection<Query> getClauses(BooleanClause.Occur occur) {
        if (this.mutable) {
            ArrayList<Query> queries = new ArrayList<Query>();
            for (BooleanClause clause : this.clauses) {
                if (clause.getOccur() != occur) continue;
                queries.add(clause.getQuery());
            }
            return Collections.unmodifiableList(queries);
        }
        return this.clauseSets.get((Object)occur);
    }

    @Override
    public final Iterator<BooleanClause> iterator() {
        return this.clauses.iterator();
    }

    private BooleanQuery rewriteNoScoring() {
        Builder newQuery = new Builder();
        newQuery.setMinimumNumberShouldMatch(this.getMinimumNumberShouldMatch());
        for (BooleanClause clause : this.clauses) {
            if (clause.getOccur() == BooleanClause.Occur.MUST) {
                newQuery.add(clause.getQuery(), BooleanClause.Occur.FILTER);
                continue;
            }
            newQuery.add(clause);
        }
        return newQuery.build();
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        BooleanQuery query = this;
        if (!needsScores) {
            query = this.rewriteNoScoring();
        }
        return new BooleanWeight(query, searcher, needsScores, this.disableCoord);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten;
        if (this.getBoost() != 1.0f) {
            return super.rewrite(reader);
        }
        if (this.clauses.size() == 1) {
            BooleanClause c = this.clauses.get(0);
            Query query = c.getQuery();
            if (this.minimumNumberShouldMatch == 1 && c.getOccur() == BooleanClause.Occur.SHOULD) {
                return query;
            }
            if (this.minimumNumberShouldMatch == 0) {
                switch (c.getOccur()) {
                    case SHOULD: 
                    case MUST: {
                        return query;
                    }
                    case FILTER: {
                        return new BoostQuery(new ConstantScoreQuery(query), 0.0f);
                    }
                    case MUST_NOT: {
                        return new MatchNoDocsQuery();
                    }
                }
                throw new AssertionError();
            }
        }
        Builder builder = new Builder();
        builder.setDisableCoord(this.isCoordDisabled());
        builder.setMinimumNumberShouldMatch(this.getMinimumNumberShouldMatch());
        boolean actuallyRewritten = false;
        for (BooleanClause booleanClause : this) {
            Query query = booleanClause.getQuery();
            rewritten = query.rewrite(reader);
            if (rewritten != query) {
                actuallyRewritten = true;
            }
            builder.add(rewritten, booleanClause.getOccur());
        }
        if (this.mutable || actuallyRewritten) {
            return builder.build();
        }
        assert (!this.mutable);
        int clauseCount = 0;
        for (Collection<Query> queries : this.clauseSets.values()) {
            clauseCount += queries.size();
        }
        if (clauseCount != this.clauses.size()) {
            Builder rewritten2 = new Builder();
            rewritten2.setDisableCoord(this.disableCoord);
            rewritten2.setMinimumNumberShouldMatch(this.minimumNumberShouldMatch);
            for (Map.Entry entry : this.clauseSets.entrySet()) {
                BooleanClause.Occur occur = (BooleanClause.Occur)((Object)entry.getKey());
                for (Query query : (Collection)entry.getValue()) {
                    rewritten2.add(query, occur);
                }
            }
            return rewritten2.build();
        }
        if (this.clauseSets.get((Object)BooleanClause.Occur.MUST).size() > 0 && this.clauseSets.get((Object)BooleanClause.Occur.FILTER).size() > 0) {
            HashSet<Query> filters = new HashSet<Query>(this.clauseSets.get((Object)BooleanClause.Occur.FILTER));
            boolean modified = filters.remove(new MatchAllDocsQuery());
            if (modified |= filters.removeAll(this.clauseSets.get((Object)BooleanClause.Occur.MUST))) {
                Builder builder2 = new Builder();
                builder2.setDisableCoord(this.isCoordDisabled());
                builder2.setMinimumNumberShouldMatch(this.getMinimumNumberShouldMatch());
                for (BooleanClause clause : this.clauses) {
                    if (clause.getOccur() == BooleanClause.Occur.FILTER) continue;
                    builder2.add(clause);
                }
                for (Query filter2 : filters) {
                    builder2.add(filter2, BooleanClause.Occur.FILTER);
                }
                return builder2.build();
            }
        }
        Collection<Query> musts = this.clauseSets.get((Object)BooleanClause.Occur.MUST);
        Collection<Query> filters = this.clauseSets.get((Object)BooleanClause.Occur.FILTER);
        if (musts.size() == 1 && filters.size() > 0) {
            Query must = musts.iterator().next();
            float f = 1.0f;
            if (must instanceof BoostQuery) {
                BoostQuery boostQuery = (BoostQuery)must;
                must = boostQuery.getQuery();
                f = boostQuery.getBoost();
            }
            if (must.getClass() == MatchAllDocsQuery.class) {
                Builder builder3 = new Builder();
                for (BooleanClause clause : this.clauses) {
                    switch (clause.getOccur()) {
                        case FILTER: 
                        case MUST_NOT: {
                            builder3.add(clause);
                            break;
                        }
                    }
                }
                rewritten = builder3.build();
                rewritten = new ConstantScoreQuery(rewritten);
                if (f != 1.0f) {
                    rewritten = new BoostQuery(rewritten, f);
                }
                builder3 = new Builder().setDisableCoord(this.isCoordDisabled()).setMinimumNumberShouldMatch(this.getMinimumNumberShouldMatch()).add(rewritten, BooleanClause.Occur.MUST);
                for (Query query : this.clauseSets.get((Object)BooleanClause.Occur.SHOULD)) {
                    builder3.add(query, BooleanClause.Occur.SHOULD);
                }
                rewritten = builder3.build();
                return rewritten;
            }
        }
        return super.rewrite(reader);
    }

    @Override
    public String toString(String field2) {
        boolean needParens;
        StringBuilder buffer = new StringBuilder();
        boolean bl = needParens = (double)this.getBoost() != 1.0 || this.getMinimumNumberShouldMatch() > 0;
        if (needParens) {
            buffer.append("(");
        }
        int i = 0;
        for (BooleanClause c : this) {
            buffer.append(c.getOccur().toString());
            Query subQuery = c.getQuery();
            if (subQuery instanceof BooleanQuery) {
                buffer.append("(");
                buffer.append(subQuery.toString(field2));
                buffer.append(")");
            } else {
                buffer.append(subQuery.toString(field2));
            }
            if (i != this.clauses.size() - 1) {
                buffer.append(" ");
            }
            ++i;
        }
        if (needParens) {
            buffer.append(")");
        }
        if (this.getMinimumNumberShouldMatch() > 0) {
            buffer.append('~');
            buffer.append(this.getMinimumNumberShouldMatch());
        }
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        BooleanQuery that = (BooleanQuery)o;
        if (this.getMinimumNumberShouldMatch() != that.getMinimumNumberShouldMatch()) {
            return false;
        }
        if (this.disableCoord != that.disableCoord) {
            return false;
        }
        if (this.mutable != that.mutable) {
            return false;
        }
        if (this.mutable) {
            return this.clauses.equals(that.clauses);
        }
        return this.clauseSets.equals(that.clauseSets);
    }

    private int computeHashCode() {
        int hashCode2 = Objects.hash(this.disableCoord, this.minimumNumberShouldMatch, this.clauseSets);
        if (hashCode2 == 0) {
            hashCode2 = 1;
        }
        return hashCode2;
    }

    @Override
    public int hashCode() {
        if (this.mutable) {
            assert (this.clauseSets == null);
            return 31 * super.hashCode() + Objects.hash(this.disableCoord, this.minimumNumberShouldMatch, this.clauses);
        }
        if (this.hashCode == 0) {
            this.hashCode = this.computeHashCode();
            assert (this.hashCode != 0);
        }
        assert (this.hashCode == this.computeHashCode());
        return 31 * super.hashCode() + this.hashCode;
    }

    @Deprecated
    public BooleanClause[] getClauses() {
        return this.clauses.toArray(new BooleanClause[this.clauses.size()]);
    }

    @Override
    public BooleanQuery clone() {
        BooleanQuery clone2 = (BooleanQuery)super.clone();
        clone2.clauses = new ArrayList<BooleanClause>(this.clauses);
        return clone2;
    }

    @Deprecated
    public BooleanQuery() {
        this(false);
    }

    @Deprecated
    public BooleanQuery(boolean disableCoord) {
        this.clauses = new ArrayList<BooleanClause>();
        this.disableCoord = disableCoord;
        this.minimumNumberShouldMatch = 0;
        this.mutable = true;
        this.clauseSets = null;
    }

    private void ensureMutable(String method) {
        if (!this.mutable) {
            throw new IllegalStateException("This BooleanQuery has been created with the new BooleanQuery.Builder API. It must not be modified afterwards. The " + method + " method only exists for backward compatibility");
        }
    }

    @Deprecated
    public void setMinimumNumberShouldMatch(int min2) {
        this.ensureMutable("setMinimumNumberShouldMatch");
        this.minimumNumberShouldMatch = min2;
    }

    @Deprecated
    public void add(Query query, BooleanClause.Occur occur) {
        this.add(new BooleanClause(query, occur));
    }

    @Deprecated
    public void add(BooleanClause clause) {
        this.ensureMutable("add");
        Objects.requireNonNull(clause, "BooleanClause must not be null");
        if (this.clauses.size() >= maxClauseCount) {
            throw new TooManyClauses();
        }
        this.clauses.add(clause);
    }

    public static class Builder {
        private boolean disableCoord;
        private int minimumNumberShouldMatch;
        private final List<BooleanClause> clauses = new ArrayList<BooleanClause>();

        public Builder setDisableCoord(boolean disableCoord) {
            this.disableCoord = disableCoord;
            return this;
        }

        public Builder setMinimumNumberShouldMatch(int min2) {
            this.minimumNumberShouldMatch = min2;
            return this;
        }

        public Builder add(BooleanClause clause) {
            this.add(clause.getQuery(), clause.getOccur());
            return this;
        }

        public Builder add(Query query, BooleanClause.Occur occur) {
            if (this.clauses.size() >= maxClauseCount) {
                throw new TooManyClauses();
            }
            this.clauses.add(new BooleanClause(query, occur));
            return this;
        }

        public BooleanQuery build() {
            return new BooleanQuery(this.disableCoord, this.minimumNumberShouldMatch, this.clauses.toArray(new BooleanClause[0]));
        }
    }

    public static class TooManyClauses
    extends RuntimeException {
        public TooManyClauses() {
            super("maxClauseCount is set to " + maxClauseCount);
        }
    }
}

