/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.surround.query;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queryparser.surround.query.SimpleTerm;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.StringHelper;

public class SrndPrefixQuery
extends SimpleTerm {
    private final BytesRef prefixRef;
    private final String prefix;
    private final char truncator;

    public SrndPrefixQuery(String prefix, boolean quoted, char truncator) {
        super(quoted);
        this.prefix = prefix;
        this.prefixRef = new BytesRef(prefix);
        this.truncator = truncator;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public char getSuffixOperator() {
        return this.truncator;
    }

    public Term getLucenePrefixTerm(String fieldName) {
        return new Term(fieldName, this.getPrefix());
    }

    @Override
    public String toStringUnquoted() {
        return this.getPrefix();
    }

    @Override
    protected void suffixToString(StringBuilder r) {
        r.append(this.getSuffixOperator());
    }

    @Override
    public void visitMatchingTerms(IndexReader reader, String fieldName, SimpleTerm.MatchingTermVisitor mtv) throws IOException {
        Terms terms = MultiFields.getTerms(reader, fieldName);
        if (terms != null) {
            TermsEnum termsEnum = terms.iterator();
            boolean skip = false;
            TermsEnum.SeekStatus status = termsEnum.seekCeil(new BytesRef(this.getPrefix()));
            if (status == TermsEnum.SeekStatus.FOUND) {
                mtv.visitMatchingTerm(this.getLucenePrefixTerm(fieldName));
            } else if (status == TermsEnum.SeekStatus.NOT_FOUND) {
                if (StringHelper.startsWith(termsEnum.term(), this.prefixRef)) {
                    mtv.visitMatchingTerm(new Term(fieldName, termsEnum.term().utf8ToString()));
                } else {
                    skip = true;
                }
            } else {
                skip = true;
            }
            if (!skip) {
                BytesRef text2;
                while ((text2 = termsEnum.next()) != null && StringHelper.startsWith(text2, this.prefixRef)) {
                    mtv.visitMatchingTerm(new Term(fieldName, text2.utf8ToString()));
                }
            }
        }
    }
}

