/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.standard.processors;

import java.util.List;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.core.nodes.FieldQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.FuzzyQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.QuotedFieldQueryNode;
import org.apache.lucene.queryparser.flexible.core.processors.QueryNodeProcessorImpl;
import org.apache.lucene.queryparser.flexible.core.util.UnescapedCharSequence;
import org.apache.lucene.queryparser.flexible.standard.nodes.PrefixWildcardQueryNode;
import org.apache.lucene.queryparser.flexible.standard.nodes.TermRangeQueryNode;
import org.apache.lucene.queryparser.flexible.standard.nodes.WildcardQueryNode;

public class WildcardQueryNodeProcessor
extends QueryNodeProcessorImpl {
    @Override
    protected QueryNode postProcessNode(QueryNode node) throws QueryNodeException {
        if (node instanceof FieldQueryNode || node instanceof FuzzyQueryNode) {
            FieldQueryNode fqn = (FieldQueryNode)node;
            CharSequence text2 = fqn.getText();
            if (fqn.getParent() instanceof TermRangeQueryNode || fqn instanceof QuotedFieldQueryNode || text2.length() <= 0) {
                return node;
            }
            if (this.isPrefixWildcard(text2)) {
                PrefixWildcardQueryNode prefixWildcardQN = new PrefixWildcardQueryNode(fqn);
                return prefixWildcardQN;
            }
            if (this.isWildcard(text2)) {
                WildcardQueryNode wildcardQN = new WildcardQueryNode(fqn);
                return wildcardQN;
            }
        }
        return node;
    }

    private boolean isWildcard(CharSequence text2) {
        if (text2 == null || text2.length() <= 0) {
            return false;
        }
        for (int i = text2.length() - 1; i >= 0; --i) {
            if (text2.charAt(i) != '*' && text2.charAt(i) != '?' || UnescapedCharSequence.wasEscaped(text2, i)) continue;
            return true;
        }
        return false;
    }

    private boolean isPrefixWildcard(CharSequence text2) {
        if (text2 == null || text2.length() <= 0 || !this.isWildcard(text2)) {
            return false;
        }
        if (text2.charAt(text2.length() - 1) != '*') {
            return false;
        }
        if (UnescapedCharSequence.wasEscaped(text2, text2.length() - 1)) {
            return false;
        }
        if (text2.length() == 1) {
            return false;
        }
        for (int i = 0; i < text2.length(); ++i) {
            if (text2.charAt(i) == '?') {
                return false;
            }
            if (text2.charAt(i) != '*' || UnescapedCharSequence.wasEscaped(text2, i)) continue;
            return i == text2.length() - 1;
        }
        return false;
    }

    @Override
    protected QueryNode preProcessNode(QueryNode node) throws QueryNodeException {
        return node;
    }

    @Override
    protected List<QueryNode> setChildrenOrder(List<QueryNode> children2) throws QueryNodeException {
        return children2;
    }
}

