/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.core.util;

import java.util.ArrayList;
import org.apache.lucene.queryparser.flexible.core.QueryNodeError;
import org.apache.lucene.queryparser.flexible.core.nodes.AndQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;

public final class QueryNodeOperation {
    private QueryNodeOperation() {
    }

    public static final QueryNode logicalAnd(QueryNode q1, QueryNode q2) {
        if (q1 == null) {
            return q2;
        }
        if (q2 == null) {
            return q1;
        }
        ANDOperation op = null;
        op = q1 instanceof AndQueryNode && q2 instanceof AndQueryNode ? ANDOperation.BOTH : (q1 instanceof AndQueryNode ? ANDOperation.Q1 : (q1 instanceof AndQueryNode ? ANDOperation.Q2 : ANDOperation.NONE));
        try {
            QueryNode result2 = null;
            switch (op) {
                case NONE: {
                    ArrayList<QueryNode> children2 = new ArrayList<QueryNode>();
                    children2.add(q1.cloneTree());
                    children2.add(q2.cloneTree());
                    result2 = new AndQueryNode(children2);
                    return result2;
                }
                case Q1: {
                    result2 = q1.cloneTree();
                    result2.add(q2.cloneTree());
                    return result2;
                }
                case Q2: {
                    result2 = q2.cloneTree();
                    result2.add(q1.cloneTree());
                    return result2;
                }
                case BOTH: {
                    result2 = q1.cloneTree();
                    result2.add(q2.cloneTree().getChildren());
                    return result2;
                }
            }
        }
        catch (CloneNotSupportedException e) {
            throw new QueryNodeError(e);
        }
        return null;
    }

    private static enum ANDOperation {
        BOTH,
        Q1,
        Q2,
        NONE;

    }
}

