/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.analyzing;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;

public class AnalyzingQueryParser
extends QueryParser {
    private final Pattern wildcardPattern = Pattern.compile("(\\.)|([?*]+)");

    public AnalyzingQueryParser(String field2, Analyzer analyzer) {
        super(field2, analyzer);
        this.setAnalyzeRangeTerms(true);
    }

    @Override
    protected Query getWildcardQuery(String field2, String termStr) throws ParseException {
        if (termStr == null) {
            throw new ParseException("Passed null value as term to getWildcardQuery");
        }
        if (!this.getAllowLeadingWildcard() && (termStr.startsWith("*") || termStr.startsWith("?"))) {
            throw new ParseException("'*' or '?' not allowed as first character in WildcardQuery unless getAllowLeadingWildcard() returns true");
        }
        Matcher wildcardMatcher = this.wildcardPattern.matcher(termStr);
        StringBuilder sb = new StringBuilder();
        int last2 = 0;
        while (wildcardMatcher.find()) {
            if (wildcardMatcher.group(1) != null) continue;
            if (wildcardMatcher.start() > 0) {
                String chunk = termStr.substring(last2, wildcardMatcher.start());
                String analyzed = this.analyzeSingleChunk(field2, termStr, chunk);
                sb.append(analyzed);
            }
            sb.append(wildcardMatcher.group(2));
            last2 = wildcardMatcher.end();
        }
        if (last2 < termStr.length()) {
            sb.append(this.analyzeSingleChunk(field2, termStr, termStr.substring(last2)));
        }
        return super.getWildcardQuery(field2, sb.toString());
    }

    @Override
    protected Query getPrefixQuery(String field2, String termStr) throws ParseException {
        String analyzed = this.analyzeSingleChunk(field2, termStr, termStr);
        return super.getPrefixQuery(field2, analyzed);
    }

    @Override
    protected Query getFuzzyQuery(String field2, String termStr, float minSimilarity) throws ParseException {
        String analyzed = this.analyzeSingleChunk(field2, termStr, termStr);
        return super.getFuzzyQuery(field2, analyzed, minSimilarity);
    }

    protected String analyzeSingleChunk(String field2, String termStr, String chunk) throws ParseException {
        String analyzed;
        block18: {
            analyzed = null;
            try (TokenStream stream = this.getAnalyzer().tokenStream(field2, chunk);){
                stream.reset();
                CharTermAttribute termAtt = stream.getAttribute(CharTermAttribute.class);
                if (stream.incrementToken()) {
                    analyzed = termAtt.toString();
                    StringBuilder multipleOutputs = null;
                    while (stream.incrementToken()) {
                        if (null == multipleOutputs) {
                            multipleOutputs = new StringBuilder();
                            multipleOutputs.append('\"');
                            multipleOutputs.append(analyzed);
                            multipleOutputs.append('\"');
                        }
                        multipleOutputs.append(',');
                        multipleOutputs.append('\"');
                        multipleOutputs.append(termAtt.toString());
                        multipleOutputs.append('\"');
                    }
                    stream.end();
                    if (null != multipleOutputs) {
                        throw new ParseException(String.format(this.getLocale(), "Analyzer created multiple terms for \"%s\": %s", chunk, multipleOutputs.toString()));
                    }
                    break block18;
                }
                stream.end();
                throw new ParseException(String.format(this.getLocale(), "Analyzer returned nothing for \"%s\"", chunk));
            }
            catch (IOException e) {
                throw new ParseException(String.format(this.getLocale(), "IO error while trying to analyze single term: \"%s\"", termStr));
            }
        }
        return analyzed;
    }
}

