/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.List;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;

public final class ReaderUtil {
    private ReaderUtil() {
    }

    public static IndexReaderContext getTopLevelContext(IndexReaderContext context) {
        while (context.parent != null) {
            context = context.parent;
        }
        return context;
    }

    public static int subIndex(int n, int[] docStarts) {
        int size2 = docStarts.length;
        int lo = 0;
        int hi = size2 - 1;
        while (hi >= lo) {
            int mid = lo + hi >>> 1;
            int midValue = docStarts[mid];
            if (n < midValue) {
                hi = mid - 1;
                continue;
            }
            if (n > midValue) {
                lo = mid + 1;
                continue;
            }
            while (mid + 1 < size2 && docStarts[mid + 1] == midValue) {
                ++mid;
            }
            return mid;
        }
        return hi;
    }

    public static int subIndex(int n, List<LeafReaderContext> leaves2) {
        int size2 = leaves2.size();
        int lo = 0;
        int hi = size2 - 1;
        while (hi >= lo) {
            int mid = lo + hi >>> 1;
            int midValue = leaves2.get((int)mid).docBase;
            if (n < midValue) {
                hi = mid - 1;
                continue;
            }
            if (n > midValue) {
                lo = mid + 1;
                continue;
            }
            while (mid + 1 < size2 && leaves2.get((int)(mid + 1)).docBase == midValue) {
                ++mid;
            }
            return mid;
        }
        return hi;
    }
}

