/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiBits;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.MultiTermsEnum;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.ReaderSlice;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;
import org.apache.lucene.util.packed.PackedLongValues;

public class MultiDocValues {
    private MultiDocValues() {
    }

    public static NumericDocValues getNormValues(IndexReader r, String field2) throws IOException {
        List<LeafReaderContext> leaves2 = r.leaves();
        int size2 = leaves2.size();
        if (size2 == 0) {
            return null;
        }
        if (size2 == 1) {
            return leaves2.get(0).reader().getNormValues(field2);
        }
        FieldInfo fi = MultiFields.getMergedFieldInfos(r).fieldInfo(field2);
        if (fi == null || !fi.hasNorms()) {
            return null;
        }
        boolean anyReal = false;
        final NumericDocValues[] values2 = new NumericDocValues[size2];
        final int[] starts2 = new int[size2 + 1];
        for (int i = 0; i < size2; ++i) {
            LeafReaderContext context = leaves2.get(i);
            NumericDocValues v = context.reader().getNormValues(field2);
            if (v == null) {
                v = DocValues.emptyNumeric();
            } else {
                anyReal = true;
            }
            values2[i] = v;
            starts2[i] = context.docBase;
        }
        starts2[size2] = r.maxDoc();
        assert (anyReal);
        return new NumericDocValues(){

            @Override
            public long get(int docID) {
                int subIndex = ReaderUtil.subIndex(docID, starts2);
                return values2[subIndex].get(docID - starts2[subIndex]);
            }
        };
    }

    public static NumericDocValues getNumericValues(IndexReader r, String field2) throws IOException {
        List<LeafReaderContext> leaves2 = r.leaves();
        int size2 = leaves2.size();
        if (size2 == 0) {
            return null;
        }
        if (size2 == 1) {
            return leaves2.get(0).reader().getNumericDocValues(field2);
        }
        boolean anyReal = false;
        final NumericDocValues[] values2 = new NumericDocValues[size2];
        final int[] starts2 = new int[size2 + 1];
        for (int i = 0; i < size2; ++i) {
            LeafReaderContext context = leaves2.get(i);
            NumericDocValues v = context.reader().getNumericDocValues(field2);
            if (v == null) {
                v = DocValues.emptyNumeric();
            } else {
                anyReal = true;
            }
            values2[i] = v;
            starts2[i] = context.docBase;
        }
        starts2[size2] = r.maxDoc();
        if (!anyReal) {
            return null;
        }
        return new NumericDocValues(){

            @Override
            public long get(int docID) {
                int subIndex = ReaderUtil.subIndex(docID, starts2);
                return values2[subIndex].get(docID - starts2[subIndex]);
            }
        };
    }

    public static Bits getDocsWithField(IndexReader r, String field2) throws IOException {
        List<LeafReaderContext> leaves2 = r.leaves();
        int size2 = leaves2.size();
        if (size2 == 0) {
            return null;
        }
        if (size2 == 1) {
            return leaves2.get(0).reader().getDocsWithField(field2);
        }
        boolean anyReal = false;
        boolean anyMissing = false;
        Bits[] values2 = new Bits[size2];
        int[] starts2 = new int[size2 + 1];
        for (int i = 0; i < size2; ++i) {
            LeafReaderContext context = leaves2.get(i);
            Bits v = context.reader().getDocsWithField(field2);
            if (v == null) {
                v = new Bits.MatchNoBits(context.reader().maxDoc());
                anyMissing = true;
            } else {
                anyReal = true;
                if (!(v instanceof Bits.MatchAllBits)) {
                    anyMissing = true;
                }
            }
            values2[i] = v;
            starts2[i] = context.docBase;
        }
        starts2[size2] = r.maxDoc();
        if (!anyReal) {
            return null;
        }
        if (!anyMissing) {
            return new Bits.MatchAllBits(r.maxDoc());
        }
        return new MultiBits(values2, starts2, false);
    }

    public static BinaryDocValues getBinaryValues(IndexReader r, String field2) throws IOException {
        List<LeafReaderContext> leaves2 = r.leaves();
        int size2 = leaves2.size();
        if (size2 == 0) {
            return null;
        }
        if (size2 == 1) {
            return leaves2.get(0).reader().getBinaryDocValues(field2);
        }
        boolean anyReal = false;
        final BinaryDocValues[] values2 = new BinaryDocValues[size2];
        final int[] starts2 = new int[size2 + 1];
        for (int i = 0; i < size2; ++i) {
            LeafReaderContext context = leaves2.get(i);
            BinaryDocValues v = context.reader().getBinaryDocValues(field2);
            if (v == null) {
                v = DocValues.emptyBinary();
            } else {
                anyReal = true;
            }
            values2[i] = v;
            starts2[i] = context.docBase;
        }
        starts2[size2] = r.maxDoc();
        if (!anyReal) {
            return null;
        }
        return new BinaryDocValues(){

            @Override
            public BytesRef get(int docID) {
                int subIndex = ReaderUtil.subIndex(docID, starts2);
                return values2[subIndex].get(docID - starts2[subIndex]);
            }
        };
    }

    public static SortedNumericDocValues getSortedNumericValues(IndexReader r, String field2) throws IOException {
        List<LeafReaderContext> leaves2 = r.leaves();
        int size2 = leaves2.size();
        if (size2 == 0) {
            return null;
        }
        if (size2 == 1) {
            return leaves2.get(0).reader().getSortedNumericDocValues(field2);
        }
        boolean anyReal = false;
        final SortedNumericDocValues[] values2 = new SortedNumericDocValues[size2];
        final int[] starts2 = new int[size2 + 1];
        for (int i = 0; i < size2; ++i) {
            LeafReaderContext context = leaves2.get(i);
            SortedNumericDocValues v = context.reader().getSortedNumericDocValues(field2);
            if (v == null) {
                v = DocValues.emptySortedNumeric(context.reader().maxDoc());
            } else {
                anyReal = true;
            }
            values2[i] = v;
            starts2[i] = context.docBase;
        }
        starts2[size2] = r.maxDoc();
        if (!anyReal) {
            return null;
        }
        return new SortedNumericDocValues(){
            SortedNumericDocValues current;

            @Override
            public void setDocument(int doc2) {
                int subIndex = ReaderUtil.subIndex(doc2, starts2);
                this.current = values2[subIndex];
                this.current.setDocument(doc2 - starts2[subIndex]);
            }

            @Override
            public long valueAt(int index) {
                return this.current.valueAt(index);
            }

            @Override
            public int count() {
                return this.current.count();
            }
        };
    }

    public static SortedDocValues getSortedValues(IndexReader r, String field2) throws IOException {
        List<LeafReaderContext> leaves2 = r.leaves();
        int size2 = leaves2.size();
        if (size2 == 0) {
            return null;
        }
        if (size2 == 1) {
            return leaves2.get(0).reader().getSortedDocValues(field2);
        }
        boolean anyReal = false;
        SortedDocValues[] values2 = new SortedDocValues[size2];
        int[] starts2 = new int[size2 + 1];
        for (int i = 0; i < size2; ++i) {
            LeafReaderContext context = leaves2.get(i);
            SortedDocValues v = context.reader().getSortedDocValues(field2);
            if (v == null) {
                v = DocValues.emptySorted();
            } else {
                anyReal = true;
            }
            values2[i] = v;
            starts2[i] = context.docBase;
        }
        starts2[size2] = r.maxDoc();
        if (!anyReal) {
            return null;
        }
        OrdinalMap mapping = OrdinalMap.build(r.getCoreCacheKey(), values2, 0.25f);
        return new MultiSortedDocValues(values2, starts2, mapping);
    }

    public static SortedSetDocValues getSortedSetValues(IndexReader r, String field2) throws IOException {
        List<LeafReaderContext> leaves2 = r.leaves();
        int size2 = leaves2.size();
        if (size2 == 0) {
            return null;
        }
        if (size2 == 1) {
            return leaves2.get(0).reader().getSortedSetDocValues(field2);
        }
        boolean anyReal = false;
        SortedSetDocValues[] values2 = new SortedSetDocValues[size2];
        int[] starts2 = new int[size2 + 1];
        for (int i = 0; i < size2; ++i) {
            LeafReaderContext context = leaves2.get(i);
            SortedSetDocValues v = context.reader().getSortedSetDocValues(field2);
            if (v == null) {
                v = DocValues.emptySortedSet();
            } else {
                anyReal = true;
            }
            values2[i] = v;
            starts2[i] = context.docBase;
        }
        starts2[size2] = r.maxDoc();
        if (!anyReal) {
            return null;
        }
        OrdinalMap mapping = OrdinalMap.build(r.getCoreCacheKey(), values2, 0.25f);
        return new MultiSortedSetDocValues(values2, starts2, mapping);
    }

    public static class MultiSortedSetDocValues
    extends SortedSetDocValues {
        public final int[] docStarts;
        public final SortedSetDocValues[] values;
        public final OrdinalMap mapping;
        int currentSubIndex;
        LongValues currentGlobalOrds;

        MultiSortedSetDocValues(SortedSetDocValues[] values2, int[] docStarts, OrdinalMap mapping) throws IOException {
            assert (docStarts.length == values2.length + 1);
            this.values = values2;
            this.docStarts = docStarts;
            this.mapping = mapping;
        }

        @Override
        public long nextOrd() {
            long segmentOrd = this.values[this.currentSubIndex].nextOrd();
            if (segmentOrd == -1L) {
                return segmentOrd;
            }
            return this.currentGlobalOrds.get(segmentOrd);
        }

        @Override
        public void setDocument(int docID) {
            this.currentSubIndex = ReaderUtil.subIndex(docID, this.docStarts);
            this.currentGlobalOrds = this.mapping.getGlobalOrds(this.currentSubIndex);
            this.values[this.currentSubIndex].setDocument(docID - this.docStarts[this.currentSubIndex]);
        }

        @Override
        public BytesRef lookupOrd(long ord) {
            int subIndex = this.mapping.getFirstSegmentNumber(ord);
            long segmentOrd = this.mapping.getFirstSegmentOrd(ord);
            return this.values[subIndex].lookupOrd(segmentOrd);
        }

        @Override
        public long getValueCount() {
            return this.mapping.getValueCount();
        }
    }

    public static class MultiSortedDocValues
    extends SortedDocValues {
        public final int[] docStarts;
        public final SortedDocValues[] values;
        public final OrdinalMap mapping;

        MultiSortedDocValues(SortedDocValues[] values2, int[] docStarts, OrdinalMap mapping) throws IOException {
            assert (docStarts.length == values2.length + 1);
            this.values = values2;
            this.docStarts = docStarts;
            this.mapping = mapping;
        }

        @Override
        public int getOrd(int docID) {
            int subIndex = ReaderUtil.subIndex(docID, this.docStarts);
            int segmentOrd = this.values[subIndex].getOrd(docID - this.docStarts[subIndex]);
            return segmentOrd == -1 ? segmentOrd : (int)this.mapping.getGlobalOrds(subIndex).get(segmentOrd);
        }

        @Override
        public BytesRef lookupOrd(int ord) {
            int subIndex = this.mapping.getFirstSegmentNumber(ord);
            int segmentOrd = (int)this.mapping.getFirstSegmentOrd(ord);
            return this.values[subIndex].lookupOrd(segmentOrd);
        }

        @Override
        public int getValueCount() {
            return (int)this.mapping.getValueCount();
        }
    }

    public static class OrdinalMap
    implements Accountable {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(OrdinalMap.class);
        final Object owner;
        final PackedLongValues globalOrdDeltas;
        final PackedLongValues firstSegments;
        final LongValues[] segmentToGlobalOrds;
        final SegmentMap segmentMap;
        final long ramBytesUsed;

        public static OrdinalMap build(Object owner2, SortedDocValues[] values2, float acceptableOverheadRatio) throws IOException {
            TermsEnum[] subs = new TermsEnum[values2.length];
            long[] weights = new long[values2.length];
            for (int i = 0; i < values2.length; ++i) {
                subs[i] = values2[i].termsEnum();
                weights[i] = values2[i].getValueCount();
            }
            return OrdinalMap.build(owner2, subs, weights, acceptableOverheadRatio);
        }

        public static OrdinalMap build(Object owner2, SortedSetDocValues[] values2, float acceptableOverheadRatio) throws IOException {
            TermsEnum[] subs = new TermsEnum[values2.length];
            long[] weights = new long[values2.length];
            for (int i = 0; i < values2.length; ++i) {
                subs[i] = values2[i].termsEnum();
                weights[i] = values2[i].getValueCount();
            }
            return OrdinalMap.build(owner2, subs, weights, acceptableOverheadRatio);
        }

        public static OrdinalMap build(Object owner2, TermsEnum[] subs, long[] weights, float acceptableOverheadRatio) throws IOException {
            if (subs.length != weights.length) {
                throw new IllegalArgumentException("subs and weights must have the same length");
            }
            SegmentMap segmentMap = new SegmentMap(weights);
            return new OrdinalMap(owner2, subs, segmentMap, acceptableOverheadRatio);
        }

        OrdinalMap(Object owner2, TermsEnum[] subs, SegmentMap segmentMap, float acceptableOverheadRatio) throws IOException {
            this.owner = owner2;
            this.segmentMap = segmentMap;
            PackedLongValues.Builder globalOrdDeltas = PackedLongValues.monotonicBuilder(0.0f);
            PackedLongValues.Builder firstSegments = PackedLongValues.packedBuilder(0.0f);
            PackedLongValues.Builder[] ordDeltas = new PackedLongValues.Builder[subs.length];
            for (int i = 0; i < ordDeltas.length; ++i) {
                ordDeltas[i] = PackedLongValues.monotonicBuilder(acceptableOverheadRatio);
            }
            long[] ordDeltaBits = new long[subs.length];
            long[] segmentOrds = new long[subs.length];
            ReaderSlice[] slices = new ReaderSlice[subs.length];
            MultiTermsEnum.TermsEnumIndex[] indexes = new MultiTermsEnum.TermsEnumIndex[slices.length];
            for (int i = 0; i < slices.length; ++i) {
                slices[i] = new ReaderSlice(0, 0, i);
                indexes[i] = new MultiTermsEnum.TermsEnumIndex(subs[segmentMap.newToOld(i)], i);
            }
            MultiTermsEnum mte = new MultiTermsEnum(slices);
            mte.reset(indexes);
            long globalOrd = 0L;
            while (mte.next() != null) {
                MultiTermsEnum.TermsEnumWithSlice[] matches = mte.getMatchArray();
                int firstSegmentIndex = Integer.MAX_VALUE;
                long globalOrdDelta = Long.MAX_VALUE;
                for (int i = 0; i < mte.getMatchCount(); ++i) {
                    int segmentIndex = matches[i].index;
                    long segmentOrd = matches[i].terms.ord();
                    long delta = globalOrd - segmentOrd;
                    if (segmentIndex < firstSegmentIndex) {
                        firstSegmentIndex = segmentIndex;
                        globalOrdDelta = delta;
                    }
                    while (segmentOrds[segmentIndex] <= segmentOrd) {
                        int n = segmentIndex;
                        ordDeltaBits[n] = ordDeltaBits[n] | delta;
                        ordDeltas[segmentIndex].add(delta);
                        int n2 = segmentIndex;
                        segmentOrds[n2] = segmentOrds[n2] + 1L;
                    }
                }
                assert (firstSegmentIndex < segmentOrds.length);
                firstSegments.add(firstSegmentIndex);
                globalOrdDeltas.add(globalOrdDelta);
                ++globalOrd;
            }
            this.firstSegments = firstSegments.build();
            this.globalOrdDeltas = globalOrdDeltas.build();
            this.segmentToGlobalOrds = new LongValues[subs.length];
            long ramBytesUsed = BASE_RAM_BYTES_USED + this.globalOrdDeltas.ramBytesUsed() + this.firstSegments.ramBytesUsed() + RamUsageEstimator.shallowSizeOf(this.segmentToGlobalOrds) + segmentMap.ramBytesUsed();
            for (int i = 0; i < ordDeltas.length; ++i) {
                final PackedLongValues deltas = ordDeltas[i].build();
                if (ordDeltaBits[i] == 0L) {
                    this.segmentToGlobalOrds[i] = LongValues.IDENTITY;
                    continue;
                }
                int bitsRequired = ordDeltaBits[i] < 0L ? 64 : PackedInts.bitsRequired(ordDeltaBits[i]);
                long monotonicBits = deltas.ramBytesUsed() * 8L;
                long packedBits = (long)bitsRequired * deltas.size();
                if (deltas.size() <= Integer.MAX_VALUE && (float)packedBits <= (float)monotonicBits * (1.0f + acceptableOverheadRatio)) {
                    int size2 = (int)deltas.size();
                    final PackedInts.Mutable newDeltas = PackedInts.getMutable(size2, bitsRequired, acceptableOverheadRatio);
                    PackedLongValues.Iterator it = deltas.iterator();
                    for (int ord = 0; ord < size2; ++ord) {
                        newDeltas.set(ord, it.next());
                    }
                    assert (!it.hasNext());
                    this.segmentToGlobalOrds[i] = new LongValues(){

                        @Override
                        public long get(long ord) {
                            return ord + newDeltas.get((int)ord);
                        }
                    };
                    ramBytesUsed += newDeltas.ramBytesUsed();
                } else {
                    this.segmentToGlobalOrds[i] = new LongValues(){

                        @Override
                        public long get(long ord) {
                            return ord + deltas.get(ord);
                        }
                    };
                    ramBytesUsed += deltas.ramBytesUsed();
                }
                ramBytesUsed += RamUsageEstimator.shallowSizeOf(this.segmentToGlobalOrds[i]);
            }
            this.ramBytesUsed = ramBytesUsed;
        }

        public LongValues getGlobalOrds(int segmentIndex) {
            return this.segmentToGlobalOrds[this.segmentMap.oldToNew(segmentIndex)];
        }

        public long getFirstSegmentOrd(long globalOrd) {
            return globalOrd - this.globalOrdDeltas.get(globalOrd);
        }

        public int getFirstSegmentNumber(long globalOrd) {
            return this.segmentMap.newToOld((int)this.firstSegments.get(globalOrd));
        }

        public long getValueCount() {
            return this.globalOrdDeltas.size();
        }

        @Override
        public long ramBytesUsed() {
            return this.ramBytesUsed;
        }

        @Override
        public Collection<Accountable> getChildResources() {
            ArrayList<Accountable> resources = new ArrayList<Accountable>();
            resources.add(Accountables.namedAccountable("global ord deltas", this.globalOrdDeltas));
            resources.add(Accountables.namedAccountable("first segments", this.firstSegments));
            resources.add(Accountables.namedAccountable("segment map", this.segmentMap));
            return resources;
        }

        private static class SegmentMap
        implements Accountable {
            private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SegmentMap.class);
            private final int[] newToOld;
            private final int[] oldToNew;

            private static int[] map(final long[] weights) {
                final int[] newToOld = new int[weights.length];
                for (int i = 0; i < weights.length; ++i) {
                    newToOld[i] = i;
                }
                new InPlaceMergeSorter(){

                    @Override
                    protected void swap(int i, int j) {
                        int tmp = newToOld[i];
                        newToOld[i] = newToOld[j];
                        newToOld[j] = tmp;
                    }

                    @Override
                    protected int compare(int i, int j) {
                        return Long.compare(weights[newToOld[j]], weights[newToOld[i]]);
                    }
                }.sort(0, weights.length);
                return newToOld;
            }

            private static int[] inverse(int[] map2) {
                int[] inverse = new int[map2.length];
                for (int i = 0; i < map2.length; ++i) {
                    inverse[map2[i]] = i;
                }
                return inverse;
            }

            SegmentMap(long[] weights) {
                this.newToOld = SegmentMap.map(weights);
                this.oldToNew = SegmentMap.inverse(this.newToOld);
                assert (Arrays.equals(this.newToOld, SegmentMap.inverse(this.oldToNew)));
            }

            int newToOld(int segment) {
                return this.newToOld[segment];
            }

            int oldToNew(int segment) {
                return this.oldToNew[segment];
            }

            @Override
            public long ramBytesUsed() {
                return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.newToOld) + RamUsageEstimator.sizeOf(this.oldToNew);
            }

            @Override
            public Collection<Accountable> getChildResources() {
                return Collections.emptyList();
            }
        }
    }
}

